/*
 * Decompiled with CFR 0.152.
 */
package infra.web.config;

import infra.beans.factory.BeanInitializationException;
import infra.context.ApplicationContext;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.NotFoundHandler;
import infra.web.accept.ContentNegotiationManager;
import infra.web.config.ResourceHandlerRegistration;
import infra.web.handler.SimpleUrlHandlerMapping;
import infra.web.resource.ResourceHttpRequestHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

public class ResourceHandlerRegistry {
    private final ApplicationContext applicationContext;
    @Nullable
    private final ContentNegotiationManager contentNegotiationManager;
    private final List<ResourceHandlerRegistration> registrations = new ArrayList<ResourceHandlerRegistration>();
    private int order = 0x7FFFFFFE;
    @Nullable
    private NotFoundHandler notFoundHandler;

    public ResourceHandlerRegistry(ApplicationContext context) {
        this(context, null);
    }

    public ResourceHandlerRegistry(ApplicationContext context, @Nullable ContentNegotiationManager contentNegotiationManager) {
        Assert.notNull((Object)context, (String)"ApplicationContext is required");
        this.applicationContext = context;
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public ResourceHandlerRegistration addResourceHandler(String ... pathPatterns) {
        ResourceHandlerRegistration registration = new ResourceHandlerRegistration(pathPatterns);
        this.registrations.add(registration);
        return registration;
    }

    public boolean hasMappingForPattern(String pathPattern) {
        for (ResourceHandlerRegistration registration : this.registrations) {
            if (!Arrays.asList(registration.getPathPatterns()).contains(pathPattern)) continue;
            return true;
        }
        return false;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setNotFoundHandler(@Nullable NotFoundHandler notFoundHandler) {
        this.notFoundHandler = notFoundHandler;
    }

    @Nullable
    protected SimpleUrlHandlerMapping getHandlerMapping() {
        if (this.registrations.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, ResourceHttpRequestHandler> urlMap = new LinkedHashMap<String, ResourceHttpRequestHandler>();
        for (ResourceHandlerRegistration registration : this.registrations) {
            ResourceHttpRequestHandler handler = this.getRequestHandler(registration);
            for (String pathPattern : registration.getPathPatterns()) {
                urlMap.put(pathPattern, handler);
            }
        }
        return new SimpleUrlHandlerMapping(urlMap, this.order);
    }

    private ResourceHttpRequestHandler getRequestHandler(ResourceHandlerRegistration registration) {
        ResourceHttpRequestHandler handler = registration.getRequestHandler();
        if (this.contentNegotiationManager != null) {
            handler.setContentNegotiationManager(this.contentNegotiationManager);
        }
        if (this.notFoundHandler != null && registration.notFoundHandler == null) {
            handler.setNotFoundHandler(this.notFoundHandler);
        }
        handler.setApplicationContext(this.applicationContext);
        try {
            handler.afterPropertiesSet();
        }
        catch (Throwable ex) {
            throw new BeanInitializationException("Failed to init ResourceHttpRequestHandler", ex);
        }
        return handler;
    }
}

