/*
 * Decompiled with CFR 0.152.
 */
package infra.web.config;

import infra.context.ApplicationContext;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.web.handler.mvc.ParameterizableViewController;
import infra.web.view.RedirectView;

public class RedirectViewControllerRegistration {
    private final String urlPath;
    private final RedirectView redirectView;
    private final ParameterizableViewController controller = new ParameterizableViewController();

    public RedirectViewControllerRegistration(String urlPath, String redirectUrl) {
        Assert.notNull((Object)urlPath, (String)"'urlPath' is required.");
        Assert.notNull((Object)redirectUrl, (String)"'redirectUrl' is required.");
        this.urlPath = urlPath;
        this.redirectView = new RedirectView(redirectUrl);
        this.controller.setView(this.redirectView);
    }

    public RedirectViewControllerRegistration setStatusCode(HttpStatusCode statusCode) {
        Assert.isTrue((boolean)statusCode.is3xxRedirection(), (String)"Not a redirect status code");
        this.redirectView.setStatusCode(statusCode);
        return this;
    }

    public RedirectViewControllerRegistration setKeepQueryParams(boolean propagate) {
        this.redirectView.setPropagateQueryParams(propagate);
        return this;
    }

    protected void setApplicationContext(@Nullable ApplicationContext applicationContext) {
        this.controller.setApplicationContext(applicationContext);
        this.redirectView.setApplicationContext(applicationContext);
    }

    protected String getUrlPath() {
        return this.urlPath;
    }

    protected ParameterizableViewController getViewController() {
        return this.controller;
    }
}

