/*
 * Decompiled with CFR 0.152.
 */
package infra.web.config;

import infra.lang.Nullable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

public class PathMatchConfigurer {
    @Nullable
    private Boolean trailingSlashMatch;
    @Nullable
    private Boolean caseSensitiveMatch;
    @Nullable
    private Map<String, Predicate<Class<?>>> pathPrefixes;

    public PathMatchConfigurer setUseCaseSensitiveMatch(@Nullable Boolean caseSensitiveMatch) {
        this.caseSensitiveMatch = caseSensitiveMatch;
        return this;
    }

    public PathMatchConfigurer setUseTrailingSlashMatch(@Nullable Boolean trailingSlashMatch) {
        this.trailingSlashMatch = trailingSlashMatch;
        return this;
    }

    public PathMatchConfigurer addPathPrefix(String prefix, Predicate<Class<?>> predicate) {
        if (this.pathPrefixes == null) {
            this.pathPrefixes = new LinkedHashMap();
        }
        this.pathPrefixes.put(prefix, predicate);
        return this;
    }

    @Nullable
    protected Map<String, Predicate<Class<?>>> getPathPrefixes() {
        return this.pathPrefixes;
    }

    @Nullable
    public Boolean isUseTrailingSlashMatch() {
        return this.trailingSlashMatch;
    }

    @Nullable
    public Boolean isUseCaseSensitiveMatch() {
        return this.caseSensitiveMatch;
    }
}

