/*
 * Decompiled with CFR 0.152.
 */
package infra.web.config;

import infra.core.Ordered;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.HandlerInterceptor;
import infra.web.handler.MappedInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InterceptorRegistration
implements Ordered {
    private final HandlerInterceptor interceptor;
    @Nullable
    private List<String> includePatterns;
    @Nullable
    private List<String> excludePatterns;
    private int order = 0;

    public InterceptorRegistration(HandlerInterceptor interceptor) {
        Assert.notNull((Object)interceptor, (String)"Interceptor is required");
        this.interceptor = interceptor;
    }

    public InterceptorRegistration addPathPatterns(String ... patterns) {
        return this.addPathPatterns(Arrays.asList(patterns));
    }

    public InterceptorRegistration addPathPatterns(List<String> patterns) {
        this.includePatterns = this.includePatterns != null ? this.includePatterns : new ArrayList(patterns.size());
        this.includePatterns.addAll(patterns);
        return this;
    }

    public InterceptorRegistration excludePathPatterns(String ... patterns) {
        return this.excludePathPatterns(Arrays.asList(patterns));
    }

    public InterceptorRegistration excludePathPatterns(List<String> patterns) {
        this.excludePatterns = this.excludePatterns != null ? this.excludePatterns : new ArrayList(patterns.size());
        this.excludePatterns.addAll(patterns);
        return this;
    }

    public InterceptorRegistration order(int order) {
        this.order = order;
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    protected Object getInterceptor() {
        if (this.includePatterns == null && this.excludePatterns == null) {
            return this.interceptor;
        }
        return new MappedInterceptor(StringUtils.toStringArray(this.includePatterns), StringUtils.toStringArray(this.excludePatterns), this.interceptor);
    }
}

