/*
 * Decompiled with CFR 0.152.
 */
package infra.web.config;

import infra.beans.factory.annotation.DisableAllDependencyInjection;
import infra.beans.factory.annotation.DisableDependencyInjection;
import infra.context.annotation.Configuration;
import infra.format.FormatterRegistry;
import infra.http.converter.HttpMessageConverter;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.validation.Validator;
import infra.web.ErrorResponse;
import infra.web.HandlerExceptionHandler;
import infra.web.bind.resolver.ParameterResolvingRegistry;
import infra.web.config.AsyncSupportConfigurer;
import infra.web.config.CompositeWebMvcConfigurer;
import infra.web.config.ContentNegotiationConfigurer;
import infra.web.config.CorsRegistry;
import infra.web.config.InterceptorRegistry;
import infra.web.config.PathMatchConfigurer;
import infra.web.config.ResourceHandlerRegistry;
import infra.web.config.ViewControllerRegistry;
import infra.web.config.ViewResolverRegistry;
import infra.web.config.WebMvcConfigurationSupport;
import infra.web.config.WebMvcConfigurer;
import infra.web.handler.ReturnValueHandlerManager;
import java.util.List;

@DisableDependencyInjection
@DisableAllDependencyInjection
@Configuration(proxyBeanMethods=false)
public class DelegatingWebMvcConfiguration
extends WebMvcConfigurationSupport {
    private final CompositeWebMvcConfigurer configurers = new CompositeWebMvcConfigurer();

    public DelegatingWebMvcConfiguration(List<WebMvcConfigurer> configurers) {
        if (CollectionUtils.isNotEmpty(configurers)) {
            this.configurers.addWebMvcConfigurers(configurers);
        }
    }

    @Override
    protected void configurePathMatch(PathMatchConfigurer configurer) {
        this.configurers.configurePathMatch(configurer);
    }

    @Override
    protected void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        this.configurers.configureContentNegotiation(configurer);
    }

    @Override
    protected void configureAsyncSupport(AsyncSupportConfigurer configurer) {
        this.configurers.configureAsyncSupport(configurer);
    }

    @Override
    protected void addFormatters(FormatterRegistry registry) {
        this.configurers.addFormatters(registry);
    }

    @Override
    protected void addInterceptors(InterceptorRegistry registry) {
        this.configurers.addInterceptors(registry);
    }

    @Override
    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
        this.configurers.addResourceHandlers(registry);
    }

    @Override
    protected void addCorsMappings(CorsRegistry registry) {
        this.configurers.addCorsMappings(registry);
    }

    @Override
    protected void addViewControllers(ViewControllerRegistry registry) {
        this.configurers.addViewControllers(registry);
    }

    @Override
    protected void configureViewResolvers(ViewResolverRegistry registry) {
        this.configurers.configureViewResolvers(registry);
    }

    @Override
    protected void modifyParameterResolvingRegistry(ParameterResolvingRegistry registry) {
        this.configurers.configureParameterResolving(registry, registry.getCustomizedStrategies());
    }

    @Override
    protected void modifyReturnValueHandlerManager(ReturnValueHandlerManager manager) {
        this.configurers.modifyReturnValueHandlerManager(manager);
    }

    @Override
    protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        this.configurers.configureMessageConverters(converters);
    }

    @Override
    protected void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        this.configurers.extendMessageConverters(converters);
    }

    @Override
    protected void configureExceptionHandlers(List<HandlerExceptionHandler> handlers) {
        this.configurers.configureExceptionHandlers(handlers);
    }

    @Override
    protected void configureErrorResponseInterceptors(List<ErrorResponse.Interceptor> interceptors) {
        this.configurers.addErrorResponseInterceptors(interceptors);
    }

    @Override
    @Nullable
    protected Validator getValidator() {
        return this.configurers.getValidator();
    }
}

