/*
 * Decompiled with CFR 0.152.
 */
package infra.web.config;

import infra.format.FormatterRegistry;
import infra.http.converter.HttpMessageConverter;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.validation.Validator;
import infra.web.ErrorResponse;
import infra.web.HandlerExceptionHandler;
import infra.web.HandlerMapping;
import infra.web.bind.resolver.ParameterResolvingRegistry;
import infra.web.bind.resolver.ParameterResolvingStrategies;
import infra.web.config.AsyncSupportConfigurer;
import infra.web.config.ContentNegotiationConfigurer;
import infra.web.config.CorsRegistry;
import infra.web.config.InterceptorRegistry;
import infra.web.config.PathMatchConfigurer;
import infra.web.config.ResourceHandlerRegistry;
import infra.web.config.ViewControllerRegistry;
import infra.web.config.ViewResolverRegistry;
import infra.web.config.WebMvcConfigurer;
import infra.web.handler.ReturnValueHandlerManager;
import java.util.ArrayList;
import java.util.List;

public class CompositeWebMvcConfigurer
implements WebMvcConfigurer {
    private final List<WebMvcConfigurer> webMvcConfigurers;

    public CompositeWebMvcConfigurer() {
        this(new ArrayList<WebMvcConfigurer>());
    }

    public CompositeWebMvcConfigurer(List<WebMvcConfigurer> webMvcConfigurers) {
        this.webMvcConfigurers = webMvcConfigurers;
    }

    public void addWebMvcConfigurers(List<WebMvcConfigurer> configurers) {
        if (CollectionUtils.isNotEmpty(configurers)) {
            this.webMvcConfigurers.addAll(configurers);
        }
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.addResourceHandlers(registry);
        }
    }

    @Override
    public void configureParameterResolving(ParameterResolvingStrategies resolvingStrategies) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.configureParameterResolving(resolvingStrategies);
        }
    }

    @Override
    public void configureParameterResolving(ParameterResolvingRegistry resolversRegistry, ParameterResolvingStrategies customizedStrategies) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.configureParameterResolving(resolversRegistry, customizedStrategies);
        }
    }

    @Override
    public void modifyReturnValueHandlerManager(ReturnValueHandlerManager manager) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.modifyReturnValueHandlerManager(manager);
        }
    }

    @Override
    public void configureHandlerRegistry(List<HandlerMapping> handlerRegistries) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.configureHandlerRegistry(handlerRegistries);
        }
    }

    @Override
    public void configureExceptionHandlers(List<HandlerExceptionHandler> handlers) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.configureExceptionHandlers(handlers);
        }
    }

    @Override
    public void extendExceptionHandlers(List<HandlerExceptionHandler> handlers) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.extendExceptionHandlers(handlers);
        }
    }

    @Override
    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.configureContentNegotiation(configurer);
        }
    }

    @Override
    public void configureViewResolvers(ViewResolverRegistry registry) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.configureViewResolvers(registry);
        }
    }

    @Override
    public void configurePathMatch(PathMatchConfigurer configurer) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.configurePathMatch(configurer);
        }
    }

    @Override
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.configureMessageConverters(converters);
        }
    }

    @Override
    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.extendMessageConverters(converters);
        }
    }

    @Override
    public void addFormatters(FormatterRegistry registry) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.addFormatters(registry);
        }
    }

    @Override
    public void addCorsMappings(CorsRegistry registry) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.addCorsMappings(registry);
        }
    }

    @Override
    public void addViewControllers(ViewControllerRegistry registry) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.addViewControllers(registry);
        }
    }

    @Override
    public void addErrorResponseInterceptors(List<ErrorResponse.Interceptor> interceptors) {
        for (WebMvcConfigurer delegate : this.getWebMvcConfigurers()) {
            delegate.addErrorResponseInterceptors(interceptors);
        }
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.addInterceptors(registry);
        }
    }

    @Override
    @Nullable
    public Validator getValidator() {
        Validator selected = null;
        for (WebMvcConfigurer configurer : this.getWebMvcConfigurers()) {
            Validator validator = configurer.getValidator();
            if (validator == null) continue;
            if (selected != null) {
                throw new IllegalStateException("No unique Validator found: {%s, %s}".formatted(selected, validator));
            }
            selected = validator;
        }
        return selected;
    }

    @Override
    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
        for (WebMvcConfigurer webMvcConfigurer : this.getWebMvcConfigurers()) {
            webMvcConfigurer.configureAsyncSupport(configurer);
        }
    }

    public List<WebMvcConfigurer> getWebMvcConfigurers() {
        return this.webMvcConfigurers;
    }
}

