/*
 * Decompiled with CFR 0.152.
 */
package infra.web.config;

import infra.core.task.AsyncTaskExecutor;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.async.CallableProcessingInterceptor;
import infra.web.async.DeferredResultProcessingInterceptor;
import java.util.ArrayList;
import java.util.List;

public class AsyncSupportConfigurer {
    @Nullable
    protected AsyncTaskExecutor taskExecutor;
    @Nullable
    protected Long timeout;
    @Nullable
    protected List<CallableProcessingInterceptor> callableInterceptors;
    @Nullable
    protected List<DeferredResultProcessingInterceptor> deferredResultInterceptors;

    public AsyncSupportConfigurer setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
        return this;
    }

    public AsyncSupportConfigurer setDefaultTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public AsyncSupportConfigurer registerCallableInterceptors(CallableProcessingInterceptor ... interceptors) {
        if (this.callableInterceptors == null) {
            this.callableInterceptors = new ArrayList<CallableProcessingInterceptor>();
        }
        CollectionUtils.addAll(this.callableInterceptors, (Object[])interceptors);
        return this;
    }

    public AsyncSupportConfigurer registerDeferredResultInterceptors(DeferredResultProcessingInterceptor ... interceptors) {
        if (this.deferredResultInterceptors == null) {
            this.deferredResultInterceptors = new ArrayList<DeferredResultProcessingInterceptor>();
        }
        CollectionUtils.addAll(this.deferredResultInterceptors, (Object[])interceptors);
        return this;
    }
}

