/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.support;

import infra.core.ParameterizedTypeReference;
import infra.http.HttpCookie;
import infra.http.HttpMethod;
import infra.http.ResponseEntity;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.concurrent.Future;
import infra.web.client.ClientResponse;
import infra.web.client.RestClient;
import infra.web.service.invoker.HttpExchangeAdapter;
import infra.web.service.invoker.HttpRequestValues;
import infra.web.util.UriBuilderFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public final class RestClientAdapter
implements HttpExchangeAdapter {
    private final RestClient restClient;
    @Nullable
    private final Executor asyncExecutor;

    private RestClientAdapter(RestClient restClient, @Nullable Executor asyncExecutor) {
        this.restClient = restClient;
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public boolean supportsRequestAttributes() {
        return true;
    }

    @Override
    public ClientResponse exchange(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).execute(false);
    }

    @Override
    public Future<ClientResponse> exchangeAsync(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).send(this.asyncExecutor);
    }

    @Override
    public <T> T exchangeForBody(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(values).retrieve().body(bodyType);
    }

    @Override
    public ResponseEntity<Void> exchangeForBodilessEntity(HttpRequestValues values) {
        return this.newRequest(values).retrieve().toBodilessEntity();
    }

    @Override
    public Future<ResponseEntity<Void>> exchangeForBodilessEntityAsync(HttpRequestValues values) {
        return this.newRequest(values).async(this.asyncExecutor).toBodilessEntity();
    }

    @Override
    public <T> ResponseEntity<T> exchangeForEntity(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(values).retrieve().toEntity(bodyType);
    }

    @Override
    public <T> Future<ResponseEntity<T>> exchangeForEntityAsync(HttpRequestValues values, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(values).async(this.asyncExecutor).toEntity(bodyType);
    }

    private RestClient.RequestBodySpec newRequest(HttpRequestValues values) {
        RestClient.RequestBodySpec bodySpec;
        HttpMethod httpMethod = values.getHttpMethod();
        Assert.notNull((Object)((Object)httpMethod), (String)"HttpMethod is required");
        RestClient.RequestBodyUriSpec uriSpec = this.restClient.method(httpMethod);
        if (values.getUri() != null) {
            bodySpec = (RestClient.RequestBodySpec)uriSpec.uri(values.getUri());
        } else if (values.getUriTemplate() != null) {
            UriBuilderFactory uriBuilderFactory = values.getUriBuilderFactory();
            if (uriBuilderFactory != null) {
                URI uri = uriBuilderFactory.expand(values.getUriTemplate(), values.getUriVariables());
                bodySpec = (RestClient.RequestBodySpec)uriSpec.uri(uri);
            } else {
                bodySpec = (RestClient.RequestBodySpec)uriSpec.uri(values.getUriTemplate(), values.getUriVariables());
            }
        } else {
            throw new IllegalStateException("Neither full URL nor URI template");
        }
        ((RestClient.RequestBodySpec)bodySpec.headers(values.getHeaders())).attributes(values.getAttributes());
        if (!values.getCookies().isEmpty()) {
            ArrayList<String> cookies = new ArrayList<String>();
            for (Map.Entry entry : values.getCookies().entrySet()) {
                String name = (String)entry.getKey();
                for (String value : (List)entry.getValue()) {
                    HttpCookie cookie = new HttpCookie(name, value);
                    cookies.add(cookie.toString());
                }
            }
            bodySpec.header("Cookie", String.join((CharSequence)"; ", cookies));
        }
        if (values.getBodyValue() != null) {
            bodySpec.body(values.getBodyValue());
        }
        return bodySpec;
    }

    public static RestClientAdapter create(RestClient restClient) {
        return RestClientAdapter.create(restClient, null);
    }

    public static RestClientAdapter create(RestClient restClient, @Nullable Executor asyncExecutor) {
        return new RestClientAdapter(restClient, asyncExecutor);
    }
}

