/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.reactive.support;

import infra.core.ParameterizedTypeReference;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferUtils;
import infra.http.HttpEntity;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.ResponseEntity;
import infra.http.client.ClientHttpResponse;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.StreamUtils;
import infra.util.concurrent.Future;
import infra.web.client.ClientResponse;
import infra.web.client.reactive.WebClient;
import infra.web.service.invoker.AbstractReactorHttpExchangeAdapter;
import infra.web.service.invoker.HttpRequestValues;
import infra.web.service.invoker.ReactiveHttpRequestValues;
import infra.web.util.UriBuilderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WebClientAdapter
extends AbstractReactorHttpExchangeAdapter {
    private final WebClient webClient;

    private WebClientAdapter(WebClient webClient) {
        this.webClient = webClient;
    }

    @Override
    public boolean supportsRequestAttributes() {
        return true;
    }

    @Override
    public Mono<Void> exchangeForMono(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).retrieve().toBodilessEntity().then();
    }

    @Override
    public Mono<HttpHeaders> exchangeForHeadersMono(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).retrieve().toBodilessEntity().map(HttpEntity::getHeaders);
    }

    @Override
    public <T> Mono<T> exchangeForBodyMono(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().bodyToMono(bodyType);
    }

    @Override
    public <T> Flux<T> exchangeForBodyFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().bodyToFlux(bodyType);
    }

    @Override
    public Mono<ResponseEntity<Void>> exchangeForBodilessEntityMono(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).retrieve().toBodilessEntity();
    }

    @Override
    public <T> Mono<ResponseEntity<T>> exchangeForEntityMono(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().toEntity(bodyType);
    }

    @Override
    public <T> Mono<ResponseEntity<Flux<T>>> exchangeForEntityFlux(HttpRequestValues requestValues, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(requestValues).retrieve().toEntityFlux(bodyType);
    }

    @Override
    public ClientResponse exchange(HttpRequestValues requestValues) {
        return (ClientResponse)this.blockingGet(this.newRequest(requestValues).exchange().map(x$0 -> new ReactorClientResponse((infra.web.client.reactive.ClientResponse)x$0)));
    }

    @Override
    public Future<ClientResponse> exchangeAsync(HttpRequestValues requestValues) {
        return Future.forAdaption((CompletionStage)this.newRequest(requestValues).exchange().toFuture()).map(x$0 -> new ReactorClientResponse((infra.web.client.reactive.ClientResponse)x$0));
    }

    @Override
    public Mono<infra.web.client.reactive.ClientResponse> exchangeMono(HttpRequestValues requestValues) {
        return this.newRequest(requestValues).exchange();
    }

    private WebClient.RequestBodySpec newRequest(HttpRequestValues values) {
        ReactiveHttpRequestValues rrv;
        Publisher<?> body;
        WebClient.RequestBodySpec bodySpec;
        HttpMethod httpMethod = values.getHttpMethod();
        Assert.notNull((Object)((Object)httpMethod), (String)"HttpMethod is required");
        WebClient.RequestBodyUriSpec uriSpec = this.webClient.method(httpMethod);
        if (values.getUri() != null) {
            bodySpec = (WebClient.RequestBodySpec)uriSpec.uri(values.getUri());
        } else if (values.getUriTemplate() != null) {
            UriBuilderFactory uriBuilderFactory = values.getUriBuilderFactory();
            bodySpec = uriBuilderFactory != null ? (WebClient.RequestBodySpec)uriSpec.uri(uriBuilderFactory.expand(values.getUriTemplate(), values.getUriVariables())) : (WebClient.RequestBodySpec)uriSpec.uri(values.getUriTemplate(), values.getUriVariables());
        } else {
            throw new IllegalStateException("Neither full URL nor URI template");
        }
        ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)bodySpec.headers(values.getHeaders())).cookies(values.getCookies())).attributes(values.getAttributes());
        if (values.getBodyValue() != null) {
            bodySpec.bodyValue(values.getBodyValue());
        } else if (values instanceof ReactiveHttpRequestValues && (body = (rrv = (ReactiveHttpRequestValues)values).getBodyPublisher()) != null) {
            ParameterizedTypeReference<?> elementType = rrv.getBodyPublisherElementType();
            Assert.notNull(elementType, (String)"Publisher body element type is required");
            bodySpec.body((Object)body, elementType);
        }
        return bodySpec;
    }

    public static WebClientAdapter forClient(WebClient webClient) {
        return new WebClientAdapter(webClient);
    }

    final class ReactorClientResponse
    implements ClientHttpResponse,
    ClientResponse {
        private final infra.web.client.reactive.ClientResponse clientResponse;
        @Nullable
        private volatile InputStream body;

        private ReactorClientResponse(infra.web.client.reactive.ClientResponse clientResponse) {
            this.clientResponse = clientResponse;
        }

        @Override
        public HttpStatusCode getStatusCode() {
            return this.clientResponse.statusCode();
        }

        @Override
        public String getStatusText() {
            HttpStatusCode httpStatusCode = this.getStatusCode();
            if (httpStatusCode instanceof HttpStatus) {
                HttpStatus status = (HttpStatus)httpStatusCode;
                return status.getReasonPhrase();
            }
            return "";
        }

        @Override
        public void close() {
            InputStream body = this.body;
            if (body != null) {
                try (InputStream inputStream = body;){
                    StreamUtils.drain((InputStream)this.body);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public InputStream getBody() {
            InputStream body = this.body;
            if (body != null) {
                return body;
            }
            Mono inputStreamMono = this.clientResponse.body((response, context) -> DataBufferUtils.join(response.getBody())).map(DataBuffer::asInputStream);
            body = (InputStream)WebClientAdapter.this.blockingGet(inputStreamMono);
            if (body == null) {
                body = InputStream.nullInputStream();
            }
            this.body = body;
            return body;
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.clientResponse.headers().asHttpHeaders();
        }

        @Override
        @Nullable
        public <T> T bodyTo(Class<T> bodyType) {
            return (T)WebClientAdapter.this.blockingGet(this.clientResponse.bodyToMono(bodyType));
        }

        @Override
        @Nullable
        public <T> T bodyTo(ParameterizedTypeReference<T> bodyType) {
            return (T)WebClientAdapter.this.blockingGet(this.clientResponse.bodyToMono(bodyType));
        }
    }
}

