/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.reactive;

import infra.core.codec.CodecException;
import infra.http.ResponseEntity;
import infra.util.MultiValueMap;
import infra.web.client.reactive.ClientResponse;
import infra.web.client.reactive.WebClientException;
import java.util.List;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class WebClientUtils {
    public static final Predicate<? super Throwable> WRAP_EXCEPTION_PREDICATE = t -> !(t instanceof WebClientException) && !(t instanceof CodecException);

    WebClientUtils() {
    }

    public static <T> Mono<ResponseEntity<T>> mapToEntity(ClientResponse response, Mono<T> bodyMono) {
        return bodyMono.defaultIfEmpty((Object)"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n").map(body -> new ResponseEntity<Object>(body != "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n" ? body : null, (MultiValueMap<String, String>)response.headers().asHttpHeaders(), response.statusCode()));
    }

    public static <T> Mono<ResponseEntity<List<T>>> mapToEntityList(ClientResponse response, Publisher<T> body) {
        return Flux.from(body).collectList().map(list -> new ResponseEntity<List>((List)list, (MultiValueMap<String, String>)response.headers().asHttpHeaders(), response.statusCode()));
    }
}

