/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.reactive;

import infra.core.ParameterizedTypeReference;
import infra.core.ResolvableType;
import infra.http.HttpHeaders;
import infra.http.HttpRequest;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.web.client.reactive.WebClientException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class WebClientResponseException
extends WebClientException {
    private final HttpStatusCode statusCode;
    private final String statusText;
    private final byte[] responseBody;
    private final HttpHeaders headers;
    @Nullable
    private final Charset responseCharset;
    @Nullable
    private final HttpRequest request;
    @Nullable
    private Function<ResolvableType, ?> bodyDecodeFunction;

    public WebClientResponseException(int statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] body, @Nullable Charset charset) {
        this(statusCode, statusText, headers, body, charset, null);
    }

    public WebClientResponseException(int status, String reasonPhrase, @Nullable HttpHeaders headers, @Nullable byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
        this(HttpStatusCode.valueOf(status), reasonPhrase, headers, body, charset, request);
    }

    public WebClientResponseException(HttpStatusCode statusCode, String reasonPhrase, @Nullable HttpHeaders headers, @Nullable byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
        this(WebClientResponseException.initMessage(statusCode, reasonPhrase, request), statusCode, reasonPhrase, headers, body, charset, request);
    }

    private static String initMessage(HttpStatusCode status, String reasonPhrase, @Nullable HttpRequest request) {
        return status.value() + " " + reasonPhrase + (String)(request != null ? " from " + request.getMethod() + " " + request.getURI() : "");
    }

    public WebClientResponseException(String message, int statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] responseBody, @Nullable Charset charset) {
        this(message, statusCode, statusText, headers, responseBody, charset, null);
    }

    public WebClientResponseException(String message, int statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] responseBody, @Nullable Charset charset, @Nullable HttpRequest request) {
        this(message, HttpStatusCode.valueOf(statusCode), statusText, headers, responseBody, charset, request);
    }

    public WebClientResponseException(String message, HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] responseBody, @Nullable Charset charset, @Nullable HttpRequest request) {
        super(message);
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.headers = HttpHeaders.copyOf((Map<String, List<String>>)((Object)headers));
        this.responseBody = responseBody != null ? responseBody : Constant.EMPTY_BYTES;
        this.responseCharset = charset;
        this.request = request;
    }

    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    public int getRawStatusCode() {
        return this.statusCode.value();
    }

    public String getStatusText() {
        return this.statusText;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public byte[] getResponseBodyAsByteArray() {
        return this.responseBody;
    }

    public String getResponseBodyAsString() {
        return this.getResponseBodyAsString(StandardCharsets.UTF_8);
    }

    public String getResponseBodyAsString(Charset defaultCharset) {
        return new String(this.responseBody, this.responseCharset != null ? this.responseCharset : defaultCharset);
    }

    @Nullable
    public <E> E getResponseBodyAs(Class<E> targetType) {
        return this.decodeBody(ResolvableType.forClass(targetType));
    }

    @Nullable
    public <E> E getResponseBodyAs(ParameterizedTypeReference<E> targetType) {
        return this.decodeBody(ResolvableType.forType((Type)targetType.getType()));
    }

    @Nullable
    private <E> E decodeBody(ResolvableType targetType) {
        Assert.state((this.bodyDecodeFunction != null ? 1 : 0) != 0, (String)"Decoder function not set");
        return (E)this.bodyDecodeFunction.apply(targetType);
    }

    @Nullable
    public HttpRequest getRequest() {
        return this.request;
    }

    public void setBodyDecodeFunction(Function<ResolvableType, ?> decoderFunction) {
        this.bodyDecodeFunction = decoderFunction;
    }

    public String getMessage() {
        String message = String.valueOf(super.getMessage());
        if (this.shouldHintAtResponseFailure()) {
            return message + ", but response failed with cause: " + this.getCause();
        }
        return message;
    }

    private boolean shouldHintAtResponseFailure() {
        return this.statusCode.is1xxInformational() || this.statusCode.is2xxSuccessful() || this.statusCode.is3xxRedirection();
    }

    public static WebClientResponseException create(int statusCode, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
        return WebClientResponseException.create(statusCode, statusText, headers, body, charset, null);
    }

    public static WebClientResponseException create(int statusCode, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
        return WebClientResponseException.create(HttpStatusCode.valueOf(statusCode), statusText, headers, body, charset, request);
    }

    public static WebClientResponseException create(HttpStatusCode statusCode, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
        if (statusCode instanceof HttpStatus) {
            HttpStatus httpStatus = (HttpStatus)statusCode;
            return switch (httpStatus) {
                case HttpStatus.BAD_REQUEST -> new BadRequest(statusText, headers, body, charset, request);
                case HttpStatus.UNAUTHORIZED -> new Unauthorized(statusText, headers, body, charset, request);
                case HttpStatus.FORBIDDEN -> new Forbidden(statusText, headers, body, charset, request);
                case HttpStatus.NOT_FOUND -> new NotFound(statusText, headers, body, charset, request);
                case HttpStatus.METHOD_NOT_ALLOWED -> new MethodNotAllowed(statusText, headers, body, charset, request);
                case HttpStatus.NOT_ACCEPTABLE -> new NotAcceptable(statusText, headers, body, charset, request);
                case HttpStatus.CONFLICT -> new Conflict(statusText, headers, body, charset, request);
                case HttpStatus.GONE -> new Gone(statusText, headers, body, charset, request);
                case HttpStatus.UNSUPPORTED_MEDIA_TYPE -> new UnsupportedMediaType(statusText, headers, body, charset, request);
                case HttpStatus.TOO_MANY_REQUESTS -> new TooManyRequests(statusText, headers, body, charset, request);
                case HttpStatus.UNPROCESSABLE_ENTITY -> new UnprocessableEntity(statusText, headers, body, charset, request);
                case HttpStatus.INTERNAL_SERVER_ERROR -> new InternalServerError(statusText, headers, body, charset, request);
                case HttpStatus.NOT_IMPLEMENTED -> new NotImplemented(statusText, headers, body, charset, request);
                case HttpStatus.BAD_GATEWAY -> new BadGateway(statusText, headers, body, charset, request);
                case HttpStatus.SERVICE_UNAVAILABLE -> new ServiceUnavailable(statusText, headers, body, charset, request);
                case HttpStatus.GATEWAY_TIMEOUT -> new GatewayTimeout(statusText, headers, body, charset, request);
                default -> new WebClientResponseException(statusCode, statusText, headers, body, charset, request);
            };
        }
        return new WebClientResponseException(statusCode, statusText, headers, body, charset, request);
    }

    public static class BadRequest
    extends WebClientResponseException {
        BadRequest(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.BAD_REQUEST.value(), statusText, headers, body, charset, request);
        }
    }

    public static class Unauthorized
    extends WebClientResponseException {
        Unauthorized(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.UNAUTHORIZED.value(), statusText, headers, body, charset, request);
        }
    }

    public static class Forbidden
    extends WebClientResponseException {
        Forbidden(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.FORBIDDEN.value(), statusText, headers, body, charset, request);
        }
    }

    public static class NotFound
    extends WebClientResponseException {
        NotFound(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.NOT_FOUND.value(), statusText, headers, body, charset, request);
        }
    }

    public static class MethodNotAllowed
    extends WebClientResponseException {
        MethodNotAllowed(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.METHOD_NOT_ALLOWED.value(), statusText, headers, body, charset, request);
        }
    }

    public static class NotAcceptable
    extends WebClientResponseException {
        NotAcceptable(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.NOT_ACCEPTABLE.value(), statusText, headers, body, charset, request);
        }
    }

    public static class Conflict
    extends WebClientResponseException {
        Conflict(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.CONFLICT.value(), statusText, headers, body, charset, request);
        }
    }

    public static class Gone
    extends WebClientResponseException {
        Gone(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.GONE.value(), statusText, headers, body, charset, request);
        }
    }

    public static class UnsupportedMediaType
    extends WebClientResponseException {
        UnsupportedMediaType(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.UNSUPPORTED_MEDIA_TYPE.value(), statusText, headers, body, charset, request);
        }
    }

    public static class TooManyRequests
    extends WebClientResponseException {
        TooManyRequests(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.TOO_MANY_REQUESTS.value(), statusText, headers, body, charset, request);
        }
    }

    public static class UnprocessableEntity
    extends WebClientResponseException {
        UnprocessableEntity(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.UNPROCESSABLE_ENTITY.value(), statusText, headers, body, charset, request);
        }
    }

    public static class InternalServerError
    extends WebClientResponseException {
        InternalServerError(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.INTERNAL_SERVER_ERROR.value(), statusText, headers, body, charset, request);
        }
    }

    public static class NotImplemented
    extends WebClientResponseException {
        NotImplemented(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.NOT_IMPLEMENTED.value(), statusText, headers, body, charset, request);
        }
    }

    public static class BadGateway
    extends WebClientResponseException {
        BadGateway(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.BAD_GATEWAY.value(), statusText, headers, body, charset, request);
        }
    }

    public static class ServiceUnavailable
    extends WebClientResponseException {
        ServiceUnavailable(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.SERVICE_UNAVAILABLE.value(), statusText, headers, body, charset, request);
        }
    }

    public static class GatewayTimeout
    extends WebClientResponseException {
        GatewayTimeout(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.GATEWAY_TIMEOUT.value(), statusText, headers, body, charset, request);
        }
    }
}

