/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.reactive;

import infra.core.ParameterizedTypeReference;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.http.ResponseEntity;
import infra.http.client.reactive.ClientHttpConnector;
import infra.http.client.reactive.ClientHttpRequest;
import infra.http.client.reactive.ClientHttpResponse;
import infra.http.codec.ClientCodecConfigurer;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import infra.web.client.reactive.ClientResponse;
import infra.web.client.reactive.DefaultWebClientBuilder;
import infra.web.client.reactive.ExchangeFilterFunction;
import infra.web.client.reactive.ExchangeFunction;
import infra.web.client.reactive.ExchangeStrategies;
import infra.web.reactive.function.BodyExtractor;
import infra.web.reactive.function.BodyInserter;
import infra.web.util.UriBuilder;
import infra.web.util.UriBuilderFactory;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public interface WebClient {
    public RequestHeadersUriSpec<?> get();

    public RequestHeadersUriSpec<?> head();

    public RequestBodyUriSpec post();

    public RequestBodyUriSpec put();

    public RequestBodyUriSpec patch();

    public RequestHeadersUriSpec<?> delete();

    public RequestHeadersUriSpec<?> options();

    public RequestBodyUriSpec method(HttpMethod var1);

    public Builder mutate();

    public static WebClient create() {
        return new DefaultWebClientBuilder().build();
    }

    public static WebClient create(String baseURI) {
        return new DefaultWebClientBuilder().baseURI(baseURI).build();
    }

    public static WebClient create(URI baseURI) {
        return new DefaultWebClientBuilder().baseURI(baseURI).build();
    }

    public static Builder builder() {
        return new DefaultWebClientBuilder();
    }

    public static interface Builder {
        public Builder baseURI(@Nullable String var1);

        public Builder baseURI(@Nullable URI var1);

        public Builder defaultUriVariables(@Nullable Map<String, ?> var1);

        public Builder uriBuilderFactory(@Nullable UriBuilderFactory var1);

        public Builder defaultHeader(String var1, String ... var2);

        public Builder defaultHeaders(Consumer<HttpHeaders> var1);

        public Builder defaultHeaders(HttpHeaders var1);

        public Builder defaultCookie(String var1, String ... var2);

        public Builder defaultCookies(Consumer<MultiValueMap<String, String>> var1);

        public Builder defaultCookies(MultiValueMap<String, String> var1);

        public Builder defaultRequest(Consumer<RequestHeadersSpec<?>> var1);

        public Builder defaultStatusHandler(Predicate<HttpStatusCode> var1, Function<ClientResponse, Mono<? extends Throwable>> var2);

        public Builder filter(ExchangeFilterFunction var1);

        public Builder filters(Consumer<List<ExchangeFilterFunction>> var1);

        public Builder clientConnector(ClientHttpConnector var1);

        public Builder codecs(Consumer<ClientCodecConfigurer> var1);

        public Builder exchangeStrategies(ExchangeStrategies var1);

        public Builder exchangeStrategies(Consumer<ExchangeStrategies.Builder> var1);

        public Builder exchangeFunction(ExchangeFunction var1);

        public Builder apply(Consumer<Builder> var1);

        public Builder clone();

        public WebClient build();
    }

    public static interface RequestBodyUriSpec
    extends RequestBodySpec,
    RequestHeadersUriSpec<RequestBodySpec> {
    }

    public static interface RequestHeadersUriSpec<S extends RequestHeadersSpec<S>>
    extends UriSpec<S>,
    RequestHeadersSpec<S> {
    }

    public static interface ResponseSpec {
        public ResponseSpec onStatus(Predicate<HttpStatusCode> var1, Function<ClientResponse, Mono<? extends Throwable>> var2);

        public ResponseSpec onRawStatus(IntPredicate var1, Function<ClientResponse, Mono<? extends Throwable>> var2);

        public <T> Mono<T> bodyToMono(Class<T> var1);

        public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> var1);

        public <T> Flux<T> bodyToFlux(Class<T> var1);

        public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> var1);

        public <T> Mono<ResponseEntity<T>> toEntity(Class<T> var1);

        public <T> Mono<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> var1);

        public <T> Mono<ResponseEntity<List<T>>> toEntityList(Class<T> var1);

        public <T> Mono<ResponseEntity<List<T>>> toEntityList(ParameterizedTypeReference<T> var1);

        public <T> Mono<ResponseEntity<Flux<T>>> toEntityFlux(Class<T> var1);

        public <T> Mono<ResponseEntity<Flux<T>>> toEntityFlux(ParameterizedTypeReference<T> var1);

        public <T> Mono<ResponseEntity<Flux<T>>> toEntityFlux(BodyExtractor<Flux<T>, ? super ClientHttpResponse> var1);

        public Mono<ResponseEntity<Void>> toBodilessEntity();
    }

    public static interface RequestBodySpec
    extends RequestHeadersSpec<RequestBodySpec> {
        public RequestBodySpec contentLength(long var1);

        public RequestBodySpec contentType(MediaType var1);

        public RequestHeadersSpec<?> bodyValue(Object var1);

        public <T, P extends Publisher<T>> RequestHeadersSpec<?> body(P var1, Class<T> var2);

        public <T, P extends Publisher<T>> RequestHeadersSpec<?> body(P var1, ParameterizedTypeReference<T> var2);

        public RequestHeadersSpec<?> body(Object var1, Class<?> var2);

        public RequestHeadersSpec<?> body(Object var1, ParameterizedTypeReference<?> var2);

        public RequestHeadersSpec<?> body(BodyInserter<?, ? super ClientHttpRequest> var1);
    }

    public static interface RequestHeadersSpec<S extends RequestHeadersSpec<S>> {
        public S accept(MediaType ... var1);

        public S acceptCharset(Charset ... var1);

        public S cookie(String var1, String var2);

        public S cookies(Consumer<MultiValueMap<String, String>> var1);

        public S cookies(@Nullable MultiValueMap<String, String> var1);

        public S ifModifiedSince(ZonedDateTime var1);

        public S ifNoneMatch(String ... var1);

        public S header(String var1, String ... var2);

        public S headers(Consumer<HttpHeaders> var1);

        public S headers(@Nullable HttpHeaders var1);

        public S attribute(String var1, Object var2);

        public S attributes(Consumer<Map<String, Object>> var1);

        public S attributes(@Nullable Map<String, Object> var1);

        public S context(Function<Context, Context> var1);

        public S httpRequest(Consumer<ClientHttpRequest> var1);

        public ResponseSpec retrieve();

        public <V> Mono<V> exchangeToMono(Function<ClientResponse, ? extends Mono<V>> var1);

        public <V> Flux<V> exchangeToFlux(Function<ClientResponse, ? extends Flux<V>> var1);

        public Mono<ClientResponse> exchange();
    }

    public static interface UriSpec<S extends RequestHeadersSpec<?>> {
        public S uri(URI var1);

        public S uri(String var1, Object ... var2);

        public S uri(String var1, Map<String, ?> var2);

        public S uri(String var1, Function<UriBuilder, URI> var2);

        public S uri(Function<UriBuilder, URI> var1);
    }
}

