/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.reactive;

import infra.http.AbstractHttpRequest;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpRequest;
import infra.http.HttpStatusCode;
import infra.http.client.reactive.ClientHttpConnector;
import infra.http.client.reactive.ClientHttpRequest;
import infra.http.client.reactive.ClientHttpResponse;
import infra.http.codec.HttpMessageWriter;
import infra.http.codec.LoggingCodecSupport;
import infra.lang.Assert;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.LogFormatUtils;
import infra.web.client.reactive.ClientRequest;
import infra.web.client.reactive.ClientResponse;
import infra.web.client.reactive.DefaultClientResponse;
import infra.web.client.reactive.ExchangeFunction;
import infra.web.client.reactive.ExchangeStrategies;
import infra.web.client.reactive.WebClientRequestException;
import infra.web.client.reactive.WebClientUtils;
import java.net.URI;
import reactor.core.publisher.Mono;

public abstract class ExchangeFunctions {
    private static final Logger log = LoggerFactory.getLogger(ExchangeFunctions.class);

    public static ExchangeFunction create(ClientHttpConnector connector) {
        return ExchangeFunctions.create(connector, ExchangeStrategies.withDefaults());
    }

    public static ExchangeFunction create(ClientHttpConnector connector, ExchangeStrategies strategies) {
        return new DefaultExchangeFunction(connector, strategies);
    }

    private static class DefaultExchangeFunction
    implements ExchangeFunction {
        private final ClientHttpConnector connector;
        private final ExchangeStrategies strategies;
        private boolean enableLoggingRequestDetails;

        public DefaultExchangeFunction(ClientHttpConnector connector, ExchangeStrategies strategies) {
            Assert.notNull((Object)connector, (String)"ClientHttpConnector is required");
            Assert.notNull((Object)strategies, (String)"ExchangeStrategies is required");
            this.connector = connector;
            this.strategies = strategies;
            for (HttpMessageWriter<?> httpMessageWriter : strategies.messageWriters()) {
                LoggingCodecSupport codecSupport;
                if (!(httpMessageWriter instanceof LoggingCodecSupport) || !(codecSupport = (LoggingCodecSupport)((Object)httpMessageWriter)).isEnableLoggingRequestDetails()) continue;
                this.enableLoggingRequestDetails = true;
            }
        }

        @Override
        public Mono<ClientResponse> exchange(ClientRequest clientRequest) {
            Assert.notNull((Object)clientRequest, (String)"ClientRequest is required");
            HttpMethod httpMethod = clientRequest.method();
            URI uri = clientRequest.uri();
            Mono responseMono = this.connector.connect(httpMethod, uri, httpRequest -> clientRequest.writeTo((ClientHttpRequest)httpRequest, this.strategies));
            if (log.isDebugEnabled()) {
                responseMono = responseMono.doOnRequest(n -> this.logRequest(clientRequest)).doOnCancel(() -> log.debug(clientRequest.logPrefix() + "Cancel signal (to close connection)"));
            }
            return responseMono.onErrorResume(WebClientUtils.WRAP_EXCEPTION_PREDICATE, t -> this.wrapException((Throwable)t, clientRequest)).map(httpResponse -> {
                String logPrefix = this.getLogPrefix(clientRequest, (ClientHttpResponse)httpResponse);
                this.logResponse((ClientHttpResponse)httpResponse, logPrefix);
                return new DefaultClientResponse((ClientHttpResponse)httpResponse, this.strategies, logPrefix, httpMethod.name() + " " + uri, () -> this.createRequest(clientRequest));
            });
        }

        private void logRequest(ClientRequest request) {
            LogFormatUtils.traceDebug((Logger)log, traceOn -> request.logPrefix() + "HTTP " + request.method() + " " + request.uri() + (String)(traceOn != false ? ", headers=" + this.formatHeaders(request.headers()) : ""));
        }

        private String getLogPrefix(ClientRequest request, ClientHttpResponse response) {
            return request.logPrefix() + "[" + response.getId() + "] ";
        }

        private void logResponse(ClientHttpResponse response, String logPrefix) {
            LogFormatUtils.traceDebug((Logger)log, traceOn -> {
                HttpStatusCode code = response.getStatusCode();
                return logPrefix + "Response " + code + (String)(traceOn != false ? ", headers=" + this.formatHeaders(response.getHeaders()) : "");
            });
        }

        private String formatHeaders(HttpHeaders headers) {
            return this.enableLoggingRequestDetails ? headers.toString() : (headers.isEmpty() ? "{}" : "{masked}");
        }

        private <T> Mono<T> wrapException(Throwable t, ClientRequest r) {
            return Mono.error(() -> new WebClientRequestException(t, r.method(), r.uri(), r.headers()));
        }

        private HttpRequest createRequest(final ClientRequest request) {
            return new AbstractHttpRequest(){

                @Override
                public HttpMethod getMethod() {
                    return request.method();
                }

                @Override
                public URI getURI() {
                    return request.uri();
                }

                @Override
                public HttpHeaders getHeaders() {
                    return request.headers();
                }
            };
        }
    }
}

