/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.reactive;

import infra.core.io.buffer.DataBufferUtils;
import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.web.client.reactive.ClientRequest;
import infra.web.client.reactive.ClientResponse;
import infra.web.client.reactive.ExchangeFilterFunction;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class ExchangeFilterFunctions {
    private static final String BASIC_AUTHENTICATION_CREDENTIALS_ATTRIBUTE = ExchangeFilterFunctions.class.getName() + ".basicAuthenticationCredentials";

    public static ExchangeFilterFunction limitResponseSize(long maxByteCount) {
        return (request, next) -> next.exchange(request).map(response -> response.mutate().body(body -> DataBufferUtils.takeUntilByteCount((Publisher)body, (long)maxByteCount)).build());
    }

    public static ExchangeFilterFunction statusError(Predicate<HttpStatusCode> statusPredicate, Function<ClientResponse, ? extends Throwable> exceptionFunction) {
        Assert.notNull(statusPredicate, (String)"Predicate is required");
        Assert.notNull(exceptionFunction, (String)"Function is required");
        return ExchangeFilterFunction.ofResponseProcessor(response -> statusPredicate.test(response.statusCode()) ? Mono.error((Throwable)((Throwable)exceptionFunction.apply((ClientResponse)response))) : Mono.just((Object)response));
    }

    public static ExchangeFilterFunction basicAuthentication(String username, String password) {
        String encodedCredentials = HttpHeaders.encodeBasicAuth(username, password, null);
        return (request, next) -> next.exchange(ClientRequest.from(request).headers(headers -> headers.setBasicAuth(encodedCredentials)).build());
    }

    public static ExchangeFilterFunction basicAuthentication() {
        return (request, next) -> {
            Object attr = request.attributes().get(BASIC_AUTHENTICATION_CREDENTIALS_ATTRIBUTE);
            if (attr instanceof Credentials) {
                Credentials cred = (Credentials)attr;
                return next.exchange(ClientRequest.from(request).headers(headers -> headers.setBasicAuth(cred.username, cred.password)).build());
            }
            return next.exchange(request);
        };
    }

    public record Credentials(String username, String password) {
        public Credentials {
            Assert.notNull((Object)username, (String)"'username' is required");
            Assert.notNull((Object)password, (String)"'password' is required");
        }

        public static Consumer<Map<String, Object>> basicAuthenticationCredentials(String username, String password) {
            Credentials credentials = new Credentials(username, password);
            return map -> map.put(BASIC_AUTHENTICATION_CREDENTIALS_ATTRIBUTE, credentials);
        }
    }
}

