/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.reactive;

import infra.lang.Assert;
import infra.web.client.reactive.ClientRequest;
import infra.web.client.reactive.ClientResponse;
import infra.web.client.reactive.ExchangeFunction;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface ExchangeFilterFunction {
    public Mono<ClientResponse> filter(ClientRequest var1, ExchangeFunction var2);

    default public ExchangeFilterFunction andThen(ExchangeFilterFunction afterFilter) {
        Assert.notNull((Object)afterFilter, (String)"ExchangeFilterFunction is required");
        return (request, next) -> this.filter(request, afterRequest -> afterFilter.filter(afterRequest, next));
    }

    default public ExchangeFunction apply(ExchangeFunction exchange) {
        Assert.notNull((Object)exchange, (String)"ExchangeFunction is required");
        return request -> this.filter(request, exchange);
    }

    public static ExchangeFilterFunction ofRequestProcessor(Function<ClientRequest, Mono<ClientRequest>> processor) {
        Assert.notNull(processor, (String)"ClientRequest Function is required");
        return (request, next) -> ((Mono)processor.apply(request)).flatMap(next::exchange);
    }

    public static ExchangeFilterFunction ofResponseProcessor(Function<ClientResponse, Mono<ClientResponse>> processor) {
        Assert.notNull(processor, (String)"ClientResponse Function is required");
        return (request, next) -> next.exchange(request).flatMap(processor);
    }
}

