/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.reactive;

import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.http.client.reactive.ClientHttpConnector;
import infra.http.client.reactive.HttpComponentsClientHttpConnector;
import infra.http.client.reactive.JdkClientHttpConnector;
import infra.http.client.reactive.ReactorClientHttpConnector;
import infra.http.codec.ClientCodecConfigurer;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ClassUtils;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.web.client.reactive.ClientResponse;
import infra.web.client.reactive.DefaultWebClient;
import infra.web.client.reactive.ExchangeFilterFunction;
import infra.web.client.reactive.ExchangeFunction;
import infra.web.client.reactive.ExchangeFunctions;
import infra.web.client.reactive.ExchangeStrategies;
import infra.web.client.reactive.WebClient;
import infra.web.util.DefaultUriBuilderFactory;
import infra.web.util.UriBuilderFactory;
import infra.web.util.UriComponentsBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import reactor.core.publisher.Mono;

final class DefaultWebClientBuilder
implements WebClient.Builder {
    private static final boolean reactorClientPresent;
    private static final boolean httpComponentsClientPresent;
    @Nullable
    private URI baseURI;
    @Nullable
    private Map<String, ?> defaultUriVariables;
    @Nullable
    private UriBuilderFactory uriBuilderFactory;
    @Nullable
    private HttpHeaders defaultHeaders;
    @Nullable
    private MultiValueMap<String, String> defaultCookies;
    @Nullable
    private Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest;
    @Nullable
    private Map<Predicate<HttpStatusCode>, Function<ClientResponse, Mono<? extends Throwable>>> statusHandlers;
    @Nullable
    private List<ExchangeFilterFunction> filters;
    @Nullable
    private ClientHttpConnector connector;
    @Nullable
    private ExchangeStrategies strategies;
    @Nullable
    private List<Consumer<ExchangeStrategies.Builder>> strategiesConfigurers;
    @Nullable
    private ExchangeFunction exchangeFunction;

    public DefaultWebClientBuilder() {
    }

    public DefaultWebClientBuilder(DefaultWebClientBuilder other) {
        Assert.notNull((Object)other, (String)"DefaultWebClientBuilder is required");
        this.baseURI = other.baseURI;
        this.defaultUriVariables = other.defaultUriVariables != null ? new LinkedHashMap(other.defaultUriVariables) : null;
        this.uriBuilderFactory = other.uriBuilderFactory;
        if (other.defaultHeaders != null) {
            this.defaultHeaders = HttpHeaders.forWritable();
            this.defaultHeaders.putAll((Map)((Object)other.defaultHeaders));
        } else {
            this.defaultHeaders = null;
        }
        this.defaultRequest = other.defaultRequest;
        this.defaultCookies = other.defaultCookies != null ? new LinkedMultiValueMap(other.defaultCookies) : null;
        this.statusHandlers = other.statusHandlers != null ? new LinkedHashMap<Predicate<HttpStatusCode>, Function<ClientResponse, Mono<? extends Throwable>>>(other.statusHandlers) : null;
        this.filters = other.filters != null ? new ArrayList<ExchangeFilterFunction>(other.filters) : null;
        this.connector = other.connector;
        this.strategies = other.strategies;
        this.strategiesConfigurers = other.strategiesConfigurers != null ? new ArrayList<Consumer<ExchangeStrategies.Builder>>(other.strategiesConfigurers) : null;
        this.exchangeFunction = other.exchangeFunction;
    }

    @Override
    public WebClient.Builder baseURI(@Nullable String baseURI) {
        if (baseURI != null) {
            this.baseURI = URI.create(baseURI);
        }
        return this;
    }

    @Override
    public WebClient.Builder baseURI(@Nullable URI baseURI) {
        this.baseURI = baseURI;
        return this;
    }

    @Override
    public WebClient.Builder defaultUriVariables(@Nullable Map<String, ?> defaultUriVariables) {
        this.defaultUriVariables = defaultUriVariables;
        return this;
    }

    @Override
    public WebClient.Builder uriBuilderFactory(@Nullable UriBuilderFactory uriBuilderFactory) {
        this.uriBuilderFactory = uriBuilderFactory;
        return this;
    }

    @Override
    public WebClient.Builder defaultHeader(String header, String ... values) {
        this.initHeaders().setOrRemove(header, values);
        return this;
    }

    @Override
    public WebClient.Builder defaultHeaders(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.initHeaders());
        return this;
    }

    @Override
    public WebClient.Builder defaultHeaders(HttpHeaders headers) {
        this.initHeaders().setAll((Map)((Object)headers));
        return this;
    }

    private HttpHeaders initHeaders() {
        if (this.defaultHeaders == null) {
            this.defaultHeaders = HttpHeaders.forWritable();
        }
        return this.defaultHeaders;
    }

    @Override
    public WebClient.Builder defaultCookie(String cookie, String ... values) {
        this.initCookies().setOrRemove((Object)cookie, (Object[])values);
        return this;
    }

    @Override
    public WebClient.Builder defaultCookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
        cookiesConsumer.accept(this.initCookies());
        return this;
    }

    @Override
    public WebClient.Builder defaultCookies(MultiValueMap<String, String> cookies) {
        this.initHeaders().setAll((Map)cookies);
        return this;
    }

    private MultiValueMap<String, String> initCookies() {
        if (this.defaultCookies == null) {
            this.defaultCookies = new LinkedMultiValueMap(3);
        }
        return this.defaultCookies;
    }

    @Override
    public WebClient.Builder defaultRequest(Consumer<WebClient.RequestHeadersSpec<?>> defaultRequest) {
        this.defaultRequest = this.defaultRequest != null ? this.defaultRequest.andThen(defaultRequest) : defaultRequest;
        return this;
    }

    @Override
    public WebClient.Builder defaultStatusHandler(Predicate<HttpStatusCode> statusPredicate, Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction) {
        if (this.statusHandlers == null) {
            this.statusHandlers = new LinkedHashMap<Predicate<HttpStatusCode>, Function<ClientResponse, Mono<? extends Throwable>>>();
        }
        this.statusHandlers.put(statusPredicate, exceptionFunction);
        return this;
    }

    @Override
    public WebClient.Builder filter(ExchangeFilterFunction filter) {
        Assert.notNull((Object)filter, (String)"ExchangeFilterFunction is required");
        this.initFilters().add(filter);
        return this;
    }

    @Override
    public WebClient.Builder filters(Consumer<List<ExchangeFilterFunction>> filtersConsumer) {
        filtersConsumer.accept(this.initFilters());
        return this;
    }

    private List<ExchangeFilterFunction> initFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<ExchangeFilterFunction>();
        }
        return this.filters;
    }

    @Override
    public WebClient.Builder clientConnector(ClientHttpConnector connector) {
        this.connector = connector;
        return this;
    }

    @Override
    public WebClient.Builder codecs(Consumer<ClientCodecConfigurer> configurer) {
        if (this.strategiesConfigurers == null) {
            this.strategiesConfigurers = new ArrayList<Consumer<ExchangeStrategies.Builder>>(4);
        }
        this.strategiesConfigurers.add(builder -> builder.codecs(configurer));
        return this;
    }

    @Override
    public WebClient.Builder exchangeStrategies(ExchangeStrategies strategies) {
        this.strategies = strategies;
        return this;
    }

    @Override
    public WebClient.Builder exchangeStrategies(Consumer<ExchangeStrategies.Builder> configurer) {
        if (this.strategiesConfigurers == null) {
            this.strategiesConfigurers = new ArrayList<Consumer<ExchangeStrategies.Builder>>(4);
        }
        this.strategiesConfigurers.add(configurer);
        return this;
    }

    @Override
    public WebClient.Builder exchangeFunction(ExchangeFunction exchangeFunction) {
        this.exchangeFunction = exchangeFunction;
        return this;
    }

    @Override
    public WebClient.Builder apply(Consumer<WebClient.Builder> builderConsumer) {
        builderConsumer.accept(this);
        return this;
    }

    @Override
    public WebClient.Builder clone() {
        return new DefaultWebClientBuilder(this);
    }

    @Override
    public WebClient build() {
        ExchangeFunction exchange = this.exchangeFunction;
        if (exchange == null) {
            ClientHttpConnector connectorToUse = this.connector;
            if (connectorToUse == null) {
                connectorToUse = this.initConnector();
            }
            exchange = ExchangeFunctions.create(connectorToUse, this.initExchangeStrategies());
        }
        exchange = this.filterExchangeFunction(exchange);
        HttpHeaders defaultHeaders = this.defaultHeaders != null ? HttpHeaders.copyOf((Map<String, List<String>>)((Object)this.defaultHeaders)).asReadOnly() : null;
        MultiValueMap defaultCookies = this.defaultCookies != null ? MultiValueMap.copyOf(this.defaultCookies).asReadOnly() : null;
        return new DefaultWebClient(exchange, this.initUriBuilderFactory(), defaultHeaders, (MultiValueMap<String, String>)defaultCookies, this.defaultRequest, this.statusHandlers, new DefaultWebClientBuilder(this));
    }

    private ExchangeFunction filterExchangeFunction(ExchangeFunction exchange) {
        if (this.filters != null) {
            return this.filters.stream().reduce(ExchangeFilterFunction::andThen).map(filter -> filter.apply(exchange)).orElse(exchange);
        }
        return exchange;
    }

    private ClientHttpConnector initConnector() {
        if (reactorClientPresent) {
            return new ReactorClientHttpConnector();
        }
        if (httpComponentsClientPresent) {
            return new HttpComponentsClientHttpConnector();
        }
        return new JdkClientHttpConnector();
    }

    private ExchangeStrategies initExchangeStrategies() {
        if (CollectionUtils.isEmpty(this.strategiesConfigurers)) {
            return this.strategies != null ? this.strategies : ExchangeStrategies.withDefaults();
        }
        ExchangeStrategies.Builder builder = this.getOrCreateBuilder();
        for (Consumer<ExchangeStrategies.Builder> configurer : this.strategiesConfigurers) {
            configurer.accept(builder);
        }
        return builder.build();
    }

    private ExchangeStrategies.Builder getOrCreateBuilder() {
        if (this.strategies != null) {
            return this.strategies.mutate();
        }
        return ExchangeStrategies.builder();
    }

    private UriBuilderFactory initUriBuilderFactory() {
        if (this.uriBuilderFactory != null) {
            return this.uriBuilderFactory;
        }
        DefaultUriBuilderFactory factory = this.baseURI != null ? new DefaultUriBuilderFactory(UriComponentsBuilder.fromUri(this.baseURI)) : new DefaultUriBuilderFactory();
        factory.setDefaultUriVariables(this.defaultUriVariables);
        return factory;
    }

    static {
        ClassLoader loader = DefaultWebClientBuilder.class.getClassLoader();
        reactorClientPresent = ClassUtils.isPresent((String)"reactor.netty.http.client.HttpClient", (ClassLoader)loader);
        httpComponentsClientPresent = ClassUtils.isPresent((String)"org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient", (ClassLoader)loader) && ClassUtils.isPresent((String)"org.apache.hc.core5.reactive.ReactiveDataConsumer", (ClassLoader)loader);
    }
}

