/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.reactive;

import infra.http.codec.ClientCodecConfigurer;
import infra.http.codec.HttpMessageReader;
import infra.http.codec.HttpMessageWriter;
import infra.web.client.reactive.ExchangeStrategies;
import java.util.List;
import java.util.function.Consumer;

final class DefaultExchangeStrategiesBuilder
implements ExchangeStrategies.Builder {
    static final ExchangeStrategies DEFAULT_EXCHANGE_STRATEGIES;
    private final ClientCodecConfigurer codecConfigurer;

    public DefaultExchangeStrategiesBuilder() {
        this.codecConfigurer = ClientCodecConfigurer.create();
        this.codecConfigurer.registerDefaults(false);
    }

    private DefaultExchangeStrategiesBuilder(DefaultExchangeStrategies other) {
        this.codecConfigurer = other.codecConfigurer.clone();
    }

    public void defaultConfiguration() {
        this.codecConfigurer.registerDefaults(true);
    }

    @Override
    public ExchangeStrategies.Builder codecs(Consumer<ClientCodecConfigurer> consumer) {
        consumer.accept(this.codecConfigurer);
        return this;
    }

    @Override
    public ExchangeStrategies build() {
        return new DefaultExchangeStrategies(this.codecConfigurer);
    }

    static {
        DefaultExchangeStrategiesBuilder builder = new DefaultExchangeStrategiesBuilder();
        builder.defaultConfiguration();
        DEFAULT_EXCHANGE_STRATEGIES = builder.build();
    }

    private static class DefaultExchangeStrategies
    implements ExchangeStrategies {
        private final ClientCodecConfigurer codecConfigurer;
        private final List<HttpMessageReader<?>> readers;
        private final List<HttpMessageWriter<?>> writers;

        public DefaultExchangeStrategies(ClientCodecConfigurer codecConfigurer) {
            this.codecConfigurer = codecConfigurer;
            this.readers = List.copyOf(codecConfigurer.getReaders());
            this.writers = List.copyOf(codecConfigurer.getWriters());
        }

        @Override
        public List<HttpMessageReader<?>> messageReaders() {
            return this.readers;
        }

        @Override
        public List<HttpMessageWriter<?>> messageWriters() {
            return this.writers;
        }

        @Override
        public ExchangeStrategies.Builder mutate() {
            return new DefaultExchangeStrategiesBuilder(this);
        }
    }
}

