/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.reactive;

import infra.core.AttributeAccessor;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferUtils;
import infra.core.io.buffer.DefaultDataBufferFactory;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpRequest;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.ResponseCookie;
import infra.http.client.reactive.ClientHttpResponse;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.web.client.reactive.ClientResponse;
import infra.web.client.reactive.DefaultClientResponse;
import infra.web.client.reactive.ExchangeStrategies;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Flux;

final class DefaultClientResponseBuilder
implements ClientResponse.Builder {
    private static final HttpRequest EMPTY_REQUEST = new HttpRequest(){
        private final URI empty = URI.create("");

        @Override
        public HttpMethod getMethod() {
            return HttpMethod.GET;
        }

        @Override
        public URI getURI() {
            return this.empty;
        }

        @Override
        public Map<String, Object> getAttributes() {
            return Map.of();
        }

        public void copyFrom(AttributeAccessor source) {
        }

        public void clearAttributes() {
        }

        public boolean hasAttributes() {
            return false;
        }

        public boolean hasAttribute(String name) {
            return false;
        }

        public String[] getAttributeNames() {
            return Constant.EMPTY_STRING_ARRAY;
        }

        public void setAttribute(String name, @Nullable Object value) {
        }

        public void setAttributes(@Nullable Map<String, Object> attributes) {
        }

        @Nullable
        public Object getAttribute(String name) {
            return null;
        }

        @Nullable
        public Object removeAttribute(String name) {
            return null;
        }

        @Override
        public HttpHeaders getHeaders() {
            return HttpHeaders.empty();
        }
    };
    private final ExchangeStrategies strategies;
    private HttpStatusCode statusCode = HttpStatus.OK;
    @Nullable
    private HttpHeaders headers;
    @Nullable
    private MultiValueMap<String, ResponseCookie> cookies;
    private Flux<DataBuffer> body = Flux.empty();
    @Nullable
    private ClientResponse originalResponse;
    private HttpRequest request;

    DefaultClientResponseBuilder(ExchangeStrategies strategies) {
        Assert.notNull((Object)strategies, (String)"ExchangeStrategies is required");
        this.strategies = strategies;
        this.headers = HttpHeaders.forWritable();
        this.cookies = new LinkedMultiValueMap();
        this.request = EMPTY_REQUEST;
    }

    DefaultClientResponseBuilder(ClientResponse other, boolean mutate) {
        HttpRequest httpRequest;
        Assert.notNull((Object)other, (String)"ClientResponse is required");
        this.strategies = other.strategies();
        this.statusCode = other.statusCode();
        if (mutate) {
            this.body = other.bodyToFlux(DataBuffer.class);
        } else {
            this.headers = HttpHeaders.forWritable();
            this.headers.addAll((Map)((Object)other.headers().asHttpHeaders()));
        }
        this.originalResponse = other;
        if (other instanceof DefaultClientResponse) {
            DefaultClientResponse defaultClientResponse = (DefaultClientResponse)other;
            httpRequest = defaultClientResponse.request();
        } else {
            httpRequest = EMPTY_REQUEST;
        }
        this.request = httpRequest;
    }

    @Override
    public DefaultClientResponseBuilder statusCode(HttpStatusCode statusCode) {
        Assert.notNull((Object)statusCode, (String)"StatusCode is required");
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public DefaultClientResponseBuilder rawStatusCode(int statusCode) {
        return this.statusCode(HttpStatusCode.valueOf(statusCode));
    }

    @Override
    public ClientResponse.Builder header(String headerName, String ... headerValues) {
        this.getHeaders().setOrRemove(headerName, headerValues);
        return this;
    }

    @Override
    public ClientResponse.Builder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.getHeaders());
        return this;
    }

    private HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = this.originalResponse.headers().asHttpHeaders().asWritable();
        }
        return this.headers;
    }

    @Override
    public DefaultClientResponseBuilder cookie(String name, String ... values) {
        for (String value : values) {
            this.getCookies().add((Object)name, (Object)ResponseCookie.from(name, value).build());
        }
        return this;
    }

    @Override
    public ClientResponse.Builder cookies(Consumer<MultiValueMap<String, ResponseCookie>> cookiesConsumer) {
        cookiesConsumer.accept(this.getCookies());
        return this;
    }

    private MultiValueMap<String, ResponseCookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = new LinkedMultiValueMap(this.originalResponse.cookies());
        }
        return this.cookies;
    }

    @Override
    public ClientResponse.Builder body(Function<Flux<DataBuffer>, Flux<DataBuffer>> transformer) {
        this.body = transformer.apply(this.body);
        return this;
    }

    @Override
    public ClientResponse.Builder body(Flux<DataBuffer> body) {
        Assert.notNull(body, (String)"Body is required");
        this.releaseBody();
        this.body = body;
        return this;
    }

    @Override
    public ClientResponse.Builder body(String body) {
        Assert.notNull((Object)body, (String)"Body is required");
        this.releaseBody();
        this.body = Flux.just((Object)body).map(s -> {
            byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
            return DefaultDataBufferFactory.sharedInstance.wrap(bytes);
        });
        return this;
    }

    private void releaseBody() {
        this.body.subscribe(DataBufferUtils.releaseConsumer());
    }

    @Override
    public ClientResponse.Builder request(HttpRequest request) {
        Assert.notNull((Object)request, (String)"Request is required");
        this.request = request;
        return this;
    }

    @Override
    public ClientResponse build() {
        BuiltClientHttpResponse httpResponse = new BuiltClientHttpResponse(this.statusCode, this.headers, this.cookies, this.body, this.originalResponse);
        return new DefaultClientResponse(httpResponse, this.strategies, this.originalResponse != null ? this.originalResponse.logPrefix() : "", this.request.getMethod() + " " + this.request.getURI(), () -> this.request);
    }

    private record BuiltClientHttpResponse(HttpStatusCode statusCode, @Nullable HttpHeaders headers, @Nullable MultiValueMap<String, ResponseCookie> cookies, Flux<DataBuffer> body, @Nullable ClientResponse originalResponse) implements ClientHttpResponse
    {
        private BuiltClientHttpResponse(HttpStatusCode statusCode, @Nullable HttpHeaders headers, @Nullable MultiValueMap<String, ResponseCookie> cookies, Flux<DataBuffer> body, @Nullable ClientResponse originalResponse) {
            Assert.isTrue((headers != null || originalResponse != null ? 1 : 0) != 0, (String)"Expected either headers or an original response with headers.");
            Assert.isTrue((cookies != null || originalResponse != null ? 1 : 0) != 0, (String)"Expected either cookies or an original response with cookies.");
            this.statusCode = statusCode;
            this.headers = headers != null ? headers.asReadOnly() : null;
            this.cookies = cookies != null ? cookies.asReadOnly() : null;
            this.body = body;
            this.originalResponse = originalResponse;
        }

        @Override
        public HttpStatusCode getStatusCode() {
            return this.statusCode;
        }

        @Override
        public int getRawStatusCode() {
            return this.statusCode.value();
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headers != null ? this.headers : this.originalResponse.headers().asHttpHeaders();
        }

        @Override
        public MultiValueMap<String, ResponseCookie> getCookies() {
            return this.cookies != null ? this.cookies : this.originalResponse.cookies();
        }

        @Override
        public Flux<DataBuffer> getBody() {
            return this.body;
        }
    }
}

