/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.reactive;

import infra.core.ParameterizedTypeReference;
import infra.core.ResolvableType;
import infra.core.codec.Decoder;
import infra.core.codec.Hints;
import infra.core.io.buffer.DataBuffer;
import infra.core.io.buffer.DataBufferUtils;
import infra.core.io.buffer.DefaultDataBufferFactory;
import infra.http.HttpHeaders;
import infra.http.HttpRequest;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.http.ResponseCookie;
import infra.http.ResponseEntity;
import infra.http.client.reactive.ClientHttpResponse;
import infra.http.codec.DecoderHttpMessageReader;
import infra.http.codec.HttpMessageReader;
import infra.http.server.reactive.ServerHttpResponse;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.util.MimeType;
import infra.util.MultiValueMap;
import infra.web.client.reactive.ClientResponse;
import infra.web.client.reactive.ExchangeStrategies;
import infra.web.client.reactive.UnknownHttpStatusCodeException;
import infra.web.client.reactive.WebClientResponseException;
import infra.web.client.reactive.WebClientUtils;
import infra.web.reactive.function.BodyExtractor;
import infra.web.reactive.function.BodyExtractors;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultClientResponse
implements ClientResponse {
    private static final byte[] EMPTY = Constant.EMPTY_BYTES;
    private final ClientHttpResponse response;
    private final ClientResponse.Headers headers;
    private final ExchangeStrategies strategies;
    private final String logPrefix;
    private final String requestDescription;
    private final Supplier<HttpRequest> requestSupplier;
    private final BodyExtractor.Context bodyExtractorContext;

    public DefaultClientResponse(ClientHttpResponse response, final ExchangeStrategies strategies, final String logPrefix, String requestDescription, Supplier<HttpRequest> requestSupplier) {
        this.response = response;
        this.logPrefix = logPrefix;
        this.strategies = strategies;
        this.headers = new DefaultHeaders();
        this.requestSupplier = requestSupplier;
        this.requestDescription = requestDescription;
        this.bodyExtractorContext = new BodyExtractor.Context(){

            @Override
            public List<HttpMessageReader<?>> messageReaders() {
                return strategies.messageReaders();
            }

            @Override
            public Optional<ServerHttpResponse> serverResponse() {
                return Optional.empty();
            }

            @Override
            public Map<String, Object> hints() {
                return Hints.from((String)Hints.LOG_PREFIX_HINT, (Object)logPrefix);
            }
        };
    }

    @Override
    public ExchangeStrategies strategies() {
        return this.strategies;
    }

    @Override
    public HttpStatusCode statusCode() {
        return this.response.getStatusCode();
    }

    @Override
    public int rawStatusCode() {
        return this.response.getRawStatusCode();
    }

    @Override
    public ClientResponse.Headers headers() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, ResponseCookie> cookies() {
        return this.response.getCookies();
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ClientHttpResponse> extractor) {
        T result = extractor.extract(this.response, this.bodyExtractorContext);
        if (result instanceof Mono) {
            Mono mono = (Mono)result;
            return (T)mono.checkpoint("Body from " + this.requestDescription + " [DefaultClientResponse]");
        }
        if (result instanceof Flux) {
            Flux flux = (Flux)result;
            return (T)flux.checkpoint("Body from " + this.requestDescription + " [DefaultClientResponse]");
        }
        return result;
    }

    @Override
    public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
        return this.body(BodyExtractors.toMono(elementClass));
    }

    @Override
    public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> elementTypeRef) {
        return this.body(BodyExtractors.toMono(elementTypeRef));
    }

    @Override
    public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
        return elementClass.equals(DataBuffer.class) ? this.body(BodyExtractors.toDataBuffers()) : this.body(BodyExtractors.toFlux(elementClass));
    }

    @Override
    public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> elementTypeRef) {
        return this.body(BodyExtractors.toFlux(elementTypeRef));
    }

    @Override
    public Mono<Void> releaseBody() {
        return this.body(BodyExtractors.toDataBuffers()).map(DataBufferUtils::release).then();
    }

    @Override
    public Mono<ResponseEntity<Void>> toBodilessEntity() {
        return this.releaseBody().then(WebClientUtils.mapToEntity(this, Mono.empty()));
    }

    @Override
    public <T> Mono<ResponseEntity<T>> toEntity(Class<T> bodyType) {
        return WebClientUtils.mapToEntity(this, this.bodyToMono(bodyType));
    }

    @Override
    public <T> Mono<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> bodyTypeReference) {
        return WebClientUtils.mapToEntity(this, this.bodyToMono(bodyTypeReference));
    }

    @Override
    public <T> Mono<ResponseEntity<List<T>>> toEntityList(Class<T> elementClass) {
        return WebClientUtils.mapToEntityList(this, this.bodyToFlux(elementClass));
    }

    @Override
    public <T> Mono<ResponseEntity<List<T>>> toEntityList(ParameterizedTypeReference<T> elementTypeRef) {
        return WebClientUtils.mapToEntityList(this, this.bodyToFlux(elementTypeRef));
    }

    @Override
    public Mono<WebClientResponseException> createException() {
        return this.bodyToMono(byte[].class).defaultIfEmpty((Object)EMPTY).onErrorReturn(ex -> !(ex instanceof Error), (Object)EMPTY).map(bodyBytes -> {
            WebClientResponseException exception;
            HttpRequest request = this.requestSupplier.get();
            Optional<MediaType> mediaType = this.headers().contentType();
            Charset charset = mediaType.map(MimeType::getCharset).orElse(null);
            HttpStatusCode statusCode = this.statusCode();
            if (statusCode instanceof HttpStatus) {
                HttpStatus httpStatus = (HttpStatus)statusCode;
                exception = WebClientResponseException.create(statusCode, httpStatus.getReasonPhrase(), this.headers().asHttpHeaders(), bodyBytes, charset, request);
            } else {
                exception = new UnknownHttpStatusCodeException(statusCode, this.headers().asHttpHeaders(), (byte[])bodyBytes, charset, request);
            }
            exception.setBodyDecodeFunction(this.initDecodeFunction((byte[])bodyBytes, mediaType.orElse(null)));
            return exception;
        });
    }

    private Function<ResolvableType, ?> initDecodeFunction(@Nullable byte[] body, @Nullable MediaType contentType) {
        return targetType -> {
            if (body == null || body.length == 0) {
                return null;
            }
            Decoder decoder = null;
            for (HttpMessageReader<?> reader : this.strategies().messageReaders()) {
                if (!reader.canRead((ResolvableType)targetType, contentType) || !(reader instanceof DecoderHttpMessageReader)) continue;
                DecoderHttpMessageReader decoderReader = (DecoderHttpMessageReader)reader;
                decoder = decoderReader.getDecoder();
                break;
            }
            Assert.state((decoder != null ? 1 : 0) != 0, (String)"No suitable decoder");
            DataBuffer buffer = DefaultDataBufferFactory.sharedInstance.wrap(body);
            return decoder.decode(buffer, targetType, null, Collections.emptyMap());
        };
    }

    @Override
    public <T> Mono<T> createError() {
        return this.createException().flatMap(Mono::error);
    }

    @Override
    public String logPrefix() {
        return this.logPrefix;
    }

    HttpRequest request() {
        return this.requestSupplier.get();
    }

    private class DefaultHeaders
    implements ClientResponse.Headers {
        private final HttpHeaders httpHeaders;

        private DefaultHeaders() {
            this.httpHeaders = DefaultClientResponse.this.response.getHeaders().asReadOnly();
        }

        @Override
        public OptionalLong contentLength() {
            return this.toOptionalLong(this.httpHeaders.getContentLength());
        }

        @Override
        public Optional<MediaType> contentType() {
            return Optional.ofNullable(this.httpHeaders.getContentType());
        }

        @Override
        public List<String> header(String headerName) {
            List<String> headerValues = this.httpHeaders.get(headerName);
            return headerValues != null ? headerValues : Collections.emptyList();
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return this.httpHeaders;
        }

        private OptionalLong toOptionalLong(long value) {
            return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
        }
    }
}

