/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.reactive;

import infra.core.ParameterizedTypeReference;
import infra.core.codec.Hints;
import infra.http.HttpCookie;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.client.reactive.ClientHttpRequest;
import infra.http.codec.HttpMessageWriter;
import infra.http.server.reactive.ServerHttpRequest;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.util.ObjectUtils;
import infra.web.client.reactive.ClientRequest;
import infra.web.client.reactive.ExchangeStrategies;
import infra.web.reactive.function.BodyInserter;
import infra.web.reactive.function.BodyInserters;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

final class DefaultClientRequestBuilder
implements ClientRequest.Builder {
    private HttpMethod method;
    private URI uri;
    private final HttpHeaders headers = HttpHeaders.forWritable();
    private final MultiValueMap<String, String> cookies = new LinkedMultiValueMap();
    private final LinkedHashMap<String, Object> attributes = new LinkedHashMap();
    private BodyInserter<?, ? super ClientHttpRequest> body = BodyInserters.empty();
    @Nullable
    private Consumer<ClientHttpRequest> httpRequestConsumer;

    public DefaultClientRequestBuilder(ClientRequest other) {
        Assert.notNull((Object)other, (String)"ClientRequest is required");
        this.method = other.method();
        this.uri = other.uri();
        this.headers(other.headers());
        this.cookies(other.cookies());
        this.attributes(other.attributes());
        this.body(other.body());
        this.httpRequestConsumer = other.httpRequest();
    }

    public DefaultClientRequestBuilder(HttpMethod method, URI uri) {
        Assert.notNull((Object)((Object)method), (String)"HttpMethod is required");
        Assert.notNull((Object)uri, (String)"URI is required");
        this.method = method;
        this.uri = uri;
    }

    @Override
    public ClientRequest.Builder method(HttpMethod method) {
        Assert.notNull((Object)((Object)method), (String)"HttpMethod is required");
        this.method = method;
        return this;
    }

    @Override
    public ClientRequest.Builder uri(URI uri) {
        Assert.notNull((Object)uri, (String)"URI is required");
        this.uri = uri;
        return this;
    }

    @Override
    public ClientRequest.Builder header(String headerName, String ... headerValues) {
        this.headers.setOrRemove(headerName, headerValues);
        return this;
    }

    @Override
    public ClientRequest.Builder headers(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public ClientRequest.Builder headers(@Nullable HttpHeaders headers) {
        this.headers.setAll((Map)((Object)headers));
        return this;
    }

    @Override
    public ClientRequest.Builder cookie(String name, String ... values) {
        this.cookies.setOrRemove((Object)name, (Object[])values);
        return this;
    }

    @Override
    public ClientRequest.Builder cookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    @Override
    public ClientRequest.Builder cookies(@Nullable MultiValueMap<String, String> cookies) {
        this.cookies.setAll(cookies);
        return this;
    }

    @Override
    public <S, P extends Publisher<S>> ClientRequest.Builder body(P publisher, Class<S> elementClass) {
        this.body = BodyInserters.fromPublisher(publisher, elementClass);
        return this;
    }

    @Override
    public <S, P extends Publisher<S>> ClientRequest.Builder body(P publisher, ParameterizedTypeReference<S> typeReference) {
        this.body = BodyInserters.fromPublisher(publisher, typeReference);
        return this;
    }

    @Override
    public ClientRequest.Builder attribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public ClientRequest.Builder attributes(Consumer<Map<String, Object>> attributesConsumer) {
        attributesConsumer.accept(this.attributes);
        return this;
    }

    @Override
    public ClientRequest.Builder attributes(@Nullable Map<String, Object> attributes) {
        if (CollectionUtils.isNotEmpty(attributes)) {
            this.attributes.putAll(attributes);
        }
        return this;
    }

    @Override
    public ClientRequest.Builder httpRequest(Consumer<ClientHttpRequest> requestConsumer) {
        this.httpRequestConsumer = this.httpRequestConsumer != null ? this.httpRequestConsumer.andThen(requestConsumer) : requestConsumer;
        return this;
    }

    @Override
    public ClientRequest.Builder body(BodyInserter<?, ? super ClientHttpRequest> inserter) {
        this.body = inserter;
        return this;
    }

    @Override
    public ClientRequest build() {
        return new BodyInserterRequest(this.method, this.uri, this.headers, this.cookies, this.body, this.attributes, this.httpRequestConsumer);
    }

    private static class BodyInserterRequest
    implements ClientRequest {
        private final HttpMethod method;
        private final URI url;
        private final HttpHeaders headers;
        private final MultiValueMap<String, String> cookies;
        private final BodyInserter<?, ? super ClientHttpRequest> body;
        private final Map<String, Object> attributes;
        @Nullable
        private final Consumer<ClientHttpRequest> httpRequestConsumer;
        private final String logPrefix;

        public BodyInserterRequest(HttpMethod method, URI url, HttpHeaders headers, MultiValueMap<String, String> cookies, BodyInserter<?, ? super ClientHttpRequest> body, Map<String, Object> attributes, @Nullable Consumer<ClientHttpRequest> httpRequestConsumer) {
            this.url = url;
            this.method = method;
            this.headers = headers.asReadOnly();
            this.cookies = cookies.asReadOnly();
            this.body = body;
            this.attributes = Collections.unmodifiableMap(attributes);
            this.httpRequestConsumer = httpRequestConsumer;
            Object id = attributes.computeIfAbsent(LOG_ID_ATTRIBUTE, name -> ObjectUtils.getIdentityHexString((Object)this));
            this.logPrefix = "[" + id + "] ";
        }

        @Override
        public HttpMethod method() {
            return this.method;
        }

        @Override
        public URI uri() {
            return this.url;
        }

        @Override
        public HttpHeaders headers() {
            return this.headers;
        }

        @Override
        public MultiValueMap<String, String> cookies() {
            return this.cookies;
        }

        @Override
        public BodyInserter<?, ? super ClientHttpRequest> body() {
            return this.body;
        }

        @Override
        public Map<String, Object> attributes() {
            return this.attributes;
        }

        @Override
        public Consumer<ClientHttpRequest> httpRequest() {
            return this.httpRequestConsumer;
        }

        @Override
        public String logPrefix() {
            return this.logPrefix;
        }

        @Override
        public Mono<Void> writeTo(ClientHttpRequest request, final ExchangeStrategies strategies) {
            HttpHeaders requestHeaders = request.getHeaders();
            if (!this.headers.isEmpty()) {
                for (Map.Entry entry : this.headers.entrySet()) {
                    requestHeaders.putIfAbsent((String)entry.getKey(), (List)entry.getValue());
                }
            }
            MultiValueMap<String, HttpCookie> requestCookies = request.getCookies();
            if (!this.cookies.isEmpty()) {
                for (Map.Entry entry : this.cookies.entrySet()) {
                    String name = (String)entry.getKey();
                    for (String value : (List)entry.getValue()) {
                        HttpCookie cookie = new HttpCookie(name, value);
                        requestCookies.add((Object)name, (Object)cookie);
                    }
                }
            }
            request.setAttributes(this.attributes);
            if (this.httpRequestConsumer != null) {
                this.httpRequestConsumer.accept(request);
            }
            return this.body.insert(request, new BodyInserter.Context(){

                @Override
                public List<HttpMessageWriter<?>> messageWriters() {
                    return strategies.messageWriters();
                }

                @Override
                public Optional<ServerHttpRequest> serverRequest() {
                    return Optional.empty();
                }

                @Override
                public Map<String, Object> hints() {
                    return Hints.from((String)Hints.LOG_PREFIX_HINT, (Object)this.logPrefix());
                }
            });
        }
    }
}

