/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.config;

import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.client.RestTemplate;
import infra.web.util.DefaultUriBuilderFactory;
import infra.web.util.UriTemplateHandler;
import java.net.URI;
import java.util.Map;
import java.util.function.Function;

public class RootUriTemplateHandler
implements UriTemplateHandler {
    @Nullable
    private final String rootUri;
    private final UriTemplateHandler handler;

    protected RootUriTemplateHandler(UriTemplateHandler handler) {
        Assert.notNull((Object)handler, (String)"Handler is required");
        this.rootUri = null;
        this.handler = handler;
    }

    public RootUriTemplateHandler(String rootUri) {
        this(rootUri, new DefaultUriBuilderFactory());
    }

    public RootUriTemplateHandler(String rootUri, UriTemplateHandler handler) {
        Assert.notNull((Object)rootUri, (String)"RootUri is required");
        Assert.notNull((Object)handler, (String)"Handler is required");
        this.rootUri = rootUri;
        this.handler = handler;
    }

    @Override
    public URI expand(String uriTemplate, Map<String, ?> uriVariables) {
        return this.handler.expand(this.apply(uriTemplate), uriVariables);
    }

    @Override
    public URI expand(String uriTemplate, Object ... uriVariables) {
        return this.handler.expand(this.apply(uriTemplate), uriVariables);
    }

    String apply(String uriTemplate) {
        if (StringUtils.startsWithIgnoreCase((String)uriTemplate, (String)"/")) {
            return this.getRootUri() + uriTemplate;
        }
        return uriTemplate;
    }

    @Nullable
    public String getRootUri() {
        return this.rootUri;
    }

    public RootUriTemplateHandler withHandlerWrapper(Function<UriTemplateHandler, UriTemplateHandler> wrapper) {
        return new RootUriTemplateHandler(this.getRootUri(), wrapper.apply(this.handler));
    }

    public static RootUriTemplateHandler addTo(RestTemplate restTemplate, String rootUri) {
        Assert.notNull((Object)restTemplate, (String)"RestTemplate is required");
        RootUriTemplateHandler handler = new RootUriTemplateHandler(rootUri, restTemplate.getUriTemplateHandler());
        restTemplate.setUriTemplateHandler(handler);
        return handler;
    }
}

