/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.config;

import infra.lang.Assert;
import infra.web.client.RestTemplate;
import infra.web.client.config.RootUriTemplateHandler;
import infra.web.util.UriBuilder;
import infra.web.util.UriBuilderFactory;
import infra.web.util.UriComponentsBuilder;
import infra.web.util.UriTemplateHandler;

public class RootUriBuilderFactory
extends RootUriTemplateHandler
implements UriBuilderFactory {
    RootUriBuilderFactory(String rootUri) {
        super(rootUri);
    }

    RootUriBuilderFactory(String rootUri, UriTemplateHandler delegate) {
        super(rootUri, delegate);
    }

    @Override
    public UriBuilder uriString(String uriTemplate) {
        return UriComponentsBuilder.fromUriString(this.apply(uriTemplate));
    }

    @Override
    public UriBuilder builder() {
        return UriComponentsBuilder.newInstance();
    }

    static void applyTo(RestTemplate restTemplate, String rootUri) {
        Assert.notNull((Object)restTemplate, (String)"RestTemplate is required");
        RootUriBuilderFactory handler = new RootUriBuilderFactory(rootUri, restTemplate.getUriTemplateHandler());
        restTemplate.setUriTemplateHandler(handler);
    }
}

