/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.config;

import infra.http.HttpHeaders;
import infra.http.client.ClientHttpRequest;
import infra.http.client.ClientHttpRequestInitializer;
import infra.lang.Nullable;
import infra.util.LambdaSafe;
import infra.web.client.config.BasicAuthentication;
import infra.web.client.config.RestTemplateRequestCustomizer;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RestTemplateBuilderClientHttpRequestInitializer
implements ClientHttpRequestInitializer {
    @Nullable
    private final BasicAuthentication basicAuthentication;
    private final Map<String, List<String>> defaultHeaders;
    private final Set<RestTemplateRequestCustomizer<?>> requestCustomizers;

    RestTemplateBuilderClientHttpRequestInitializer(@Nullable BasicAuthentication basicAuthentication, Map<String, List<String>> defaultHeaders, Set<RestTemplateRequestCustomizer<?>> requestCustomizers) {
        this.defaultHeaders = defaultHeaders;
        this.requestCustomizers = requestCustomizers;
        this.basicAuthentication = basicAuthentication;
    }

    @Override
    public void initialize(ClientHttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        if (this.basicAuthentication != null) {
            this.basicAuthentication.applyTo(headers);
        }
        for (Map.Entry<String, List<String>> entry : this.defaultHeaders.entrySet()) {
            headers.putIfAbsent(entry.getKey(), entry.getValue());
        }
        LambdaSafe.callbacks(RestTemplateRequestCustomizer.class, this.requestCustomizers, (Object)request, (Object[])new Object[0]).invoke(customizer -> customizer.customize(request));
    }
}

