/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.config;

import infra.beans.BeanUtils;
import infra.core.ssl.SslBundle;
import infra.http.client.ClientHttpRequestFactory;
import infra.http.client.ClientHttpRequestInterceptor;
import infra.http.converter.HttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.client.ResponseErrorHandler;
import infra.web.client.RestTemplate;
import infra.web.client.config.BasicAuthentication;
import infra.web.client.config.ClientHttpRequestFactories;
import infra.web.client.config.ClientHttpRequestFactorySettings;
import infra.web.client.config.RestTemplateBuilderClientHttpRequestInitializer;
import infra.web.client.config.RestTemplateCustomizer;
import infra.web.client.config.RestTemplateRequestCustomizer;
import infra.web.client.config.RootUriBuilderFactory;
import infra.web.util.UriTemplateHandler;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class RestTemplateBuilder {
    private final ClientHttpRequestFactorySettings requestFactorySettings;
    private final boolean detectRequestFactory;
    @Nullable
    private final String rootUri;
    @Nullable
    private final Set<HttpMessageConverter<?>> messageConverters;
    private final Set<ClientHttpRequestInterceptor> interceptors;
    @Nullable
    private final Function<ClientHttpRequestFactorySettings, ClientHttpRequestFactory> requestFactory;
    @Nullable
    private final UriTemplateHandler uriTemplateHandler;
    @Nullable
    private final ResponseErrorHandler errorHandler;
    @Nullable
    private final BasicAuthentication basicAuthentication;
    private final Map<String, List<String>> defaultHeaders;
    private final Set<RestTemplateCustomizer> customizers;
    private final Set<RestTemplateRequestCustomizer<?>> requestCustomizers;

    public RestTemplateBuilder(RestTemplateCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers is required");
        this.requestFactorySettings = ClientHttpRequestFactorySettings.DEFAULTS;
        this.detectRequestFactory = true;
        this.rootUri = null;
        this.messageConverters = null;
        this.interceptors = Collections.emptySet();
        this.requestFactory = null;
        this.uriTemplateHandler = null;
        this.errorHandler = null;
        this.basicAuthentication = null;
        this.defaultHeaders = Collections.emptyMap();
        this.customizers = this.copiedSetOf(customizers);
        this.requestCustomizers = Collections.emptySet();
    }

    private RestTemplateBuilder(ClientHttpRequestFactorySettings requestFactorySettings, boolean detectRequestFactory, @Nullable String rootUri, @Nullable Set<HttpMessageConverter<?>> messageConverters, Set<ClientHttpRequestInterceptor> interceptors, @Nullable Function<ClientHttpRequestFactorySettings, ClientHttpRequestFactory> requestFactorySupplier, @Nullable UriTemplateHandler uriTemplateHandler, @Nullable ResponseErrorHandler errorHandler, @Nullable BasicAuthentication basicAuthentication, Map<String, List<String>> defaultHeaders, Set<RestTemplateCustomizer> customizers, Set<RestTemplateRequestCustomizer<?>> requestCustomizers) {
        this.requestFactorySettings = requestFactorySettings;
        this.detectRequestFactory = detectRequestFactory;
        this.rootUri = rootUri;
        this.messageConverters = messageConverters;
        this.interceptors = interceptors;
        this.requestFactory = requestFactorySupplier;
        this.uriTemplateHandler = uriTemplateHandler;
        this.errorHandler = errorHandler;
        this.basicAuthentication = basicAuthentication;
        this.defaultHeaders = defaultHeaders;
        this.customizers = customizers;
        this.requestCustomizers = requestCustomizers;
    }

    public RestTemplateBuilder detectRequestFactory(boolean detectRequestFactory) {
        return new RestTemplateBuilder(this.requestFactorySettings, detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder rootUri(String rootUri) {
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, rootUri, this.messageConverters, this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder messageConverters(HttpMessageConverter<?> ... messageConverters) {
        Assert.notNull(messageConverters, (String)"MessageConverters is required");
        return this.messageConverters(Arrays.asList(messageConverters));
    }

    public RestTemplateBuilder messageConverters(Collection<? extends HttpMessageConverter<?>> messageConverters) {
        Assert.notNull(messageConverters, (String)"MessageConverters is required");
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.copiedSetOf(messageConverters), this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder additionalMessageConverters(HttpMessageConverter<?> ... messageConverters) {
        Assert.notNull(messageConverters, (String)"MessageConverters is required");
        return this.additionalMessageConverters(Arrays.asList(messageConverters));
    }

    public RestTemplateBuilder additionalMessageConverters(Collection<? extends HttpMessageConverter<?>> messageConverters) {
        Assert.notNull(messageConverters, (String)"MessageConverters is required");
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, RestTemplateBuilder.append(this.messageConverters, messageConverters), this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder defaultMessageConverters() {
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.copiedSetOf((Collection)new RestTemplate().getMessageConverters()), this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder interceptors(ClientHttpRequestInterceptor ... interceptors) {
        Assert.notNull((Object)interceptors, (String)"interceptors is required");
        return this.interceptors(Arrays.asList(interceptors));
    }

    public RestTemplateBuilder interceptors(Collection<ClientHttpRequestInterceptor> interceptors) {
        Assert.notNull(interceptors, (String)"interceptors is required");
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.messageConverters, this.copiedSetOf(interceptors), this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder additionalInterceptors(ClientHttpRequestInterceptor ... interceptors) {
        Assert.notNull((Object)interceptors, (String)"interceptors is required");
        return this.additionalInterceptors(Arrays.asList(interceptors));
    }

    public RestTemplateBuilder additionalInterceptors(Collection<? extends ClientHttpRequestInterceptor> interceptors) {
        Assert.notNull(interceptors, (String)"interceptors is required");
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.messageConverters, RestTemplateBuilder.append(this.interceptors, interceptors), this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder requestFactory(Class<? extends ClientHttpRequestFactory> requestFactoryType) {
        Assert.notNull(requestFactoryType, (String)"RequestFactoryType is required");
        return this.requestFactory((ClientHttpRequestFactorySettings settings) -> ClientHttpRequestFactories.get(requestFactoryType, settings));
    }

    public RestTemplateBuilder requestFactory(Supplier<ClientHttpRequestFactory> requestFactory) {
        Assert.notNull(requestFactory, (String)"RequestFactory supplier is required");
        return this.requestFactory((ClientHttpRequestFactorySettings settings) -> ClientHttpRequestFactories.get(requestFactory, settings));
    }

    public RestTemplateBuilder requestFactory(Function<ClientHttpRequestFactorySettings, ClientHttpRequestFactory> requestFactoryFunction) {
        Assert.notNull(requestFactoryFunction, (String)"RequestFactoryFunction is required");
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, requestFactoryFunction, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder uriTemplateHandler(UriTemplateHandler uriTemplateHandler) {
        Assert.notNull((Object)uriTemplateHandler, (String)"UriTemplateHandler is required");
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, this.requestFactory, uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder errorHandler(ResponseErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, (String)"ErrorHandler is required");
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, this.requestFactory, this.uriTemplateHandler, errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder basicAuthentication(String username, String password) {
        return this.basicAuthentication(username, password, null);
    }

    public RestTemplateBuilder basicAuthentication(String username, String password, @Nullable Charset charset) {
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, new BasicAuthentication(username, password, charset), this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder defaultHeader(String name, String ... values) {
        Assert.notNull((Object)name, (String)"Name is required");
        Assert.notNull((Object)values, (String)"Values is required");
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, RestTemplateBuilder.append(this.defaultHeaders, name, values), this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder setConnectTimeout(Duration connectTimeout) {
        return new RestTemplateBuilder(this.requestFactorySettings.withConnectTimeout(connectTimeout), this.detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder setReadTimeout(Duration readTimeout) {
        return new RestTemplateBuilder(this.requestFactorySettings.withReadTimeout(readTimeout), this.detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder setSslBundle(SslBundle sslBundle) {
        return new RestTemplateBuilder(this.requestFactorySettings.withSslBundle(sslBundle), this.detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.requestCustomizers);
    }

    public RestTemplateBuilder customizers(RestTemplateCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers is required");
        return this.customizers(Arrays.asList(customizers));
    }

    public RestTemplateBuilder customizers(Collection<? extends RestTemplateCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers is required");
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.copiedSetOf(customizers), this.requestCustomizers);
    }

    public RestTemplateBuilder additionalCustomizers(RestTemplateCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers is required");
        return this.additionalCustomizers(Arrays.asList(customizers));
    }

    public RestTemplateBuilder additionalCustomizers(Collection<? extends RestTemplateCustomizer> customizers) {
        Assert.notNull(customizers, (String)"RestTemplateCustomizers is required");
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, RestTemplateBuilder.append(this.customizers, customizers), this.requestCustomizers);
    }

    public RestTemplateBuilder requestCustomizers(RestTemplateRequestCustomizer<?> ... requestCustomizers) {
        Assert.notNull(requestCustomizers, (String)"RequestCustomizers is required");
        return this.requestCustomizers(Arrays.asList(requestCustomizers));
    }

    public RestTemplateBuilder requestCustomizers(Collection<? extends RestTemplateRequestCustomizer<?>> requestCustomizers) {
        Assert.notNull(requestCustomizers, (String)"RequestCustomizers is required");
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, this.copiedSetOf(requestCustomizers));
    }

    public RestTemplateBuilder additionalRequestCustomizers(RestTemplateRequestCustomizer<?> ... requestCustomizers) {
        Assert.notNull(requestCustomizers, (String)"RequestCustomizers is required");
        return this.additionalRequestCustomizers(Arrays.asList(requestCustomizers));
    }

    public RestTemplateBuilder additionalRequestCustomizers(Collection<? extends RestTemplateRequestCustomizer<?>> requestCustomizers) {
        Assert.notNull(requestCustomizers, (String)"RequestCustomizers is required");
        return new RestTemplateBuilder(this.requestFactorySettings, this.detectRequestFactory, this.rootUri, this.messageConverters, this.interceptors, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthentication, this.defaultHeaders, this.customizers, RestTemplateBuilder.append(this.requestCustomizers, requestCustomizers));
    }

    public RestTemplate build() {
        return this.configure(new RestTemplate());
    }

    public <T extends RestTemplate> T build(Class<T> restTemplateClass) {
        return (T)this.configure((RestTemplate)BeanUtils.newInstance(restTemplateClass));
    }

    public <T extends RestTemplate> T configure(T restTemplate) {
        ClientHttpRequestFactory requestFactory = this.buildRequestFactory();
        if (requestFactory != null) {
            restTemplate.setRequestFactory(requestFactory);
        }
        this.addClientHttpRequestInitializer(restTemplate);
        if (CollectionUtils.isNotEmpty(this.messageConverters)) {
            restTemplate.setMessageConverters(new ArrayList(this.messageConverters));
        }
        if (this.uriTemplateHandler != null) {
            restTemplate.setUriTemplateHandler(this.uriTemplateHandler);
        }
        if (this.errorHandler != null) {
            restTemplate.setErrorHandler(this.errorHandler);
        }
        if (this.rootUri != null) {
            RootUriBuilderFactory.applyTo(restTemplate, this.rootUri);
        }
        restTemplate.getInterceptors().addAll(this.interceptors);
        if (CollectionUtils.isNotEmpty(this.customizers)) {
            for (RestTemplateCustomizer customizer : this.customizers) {
                customizer.customize(restTemplate);
            }
        }
        return restTemplate;
    }

    @Nullable
    public ClientHttpRequestFactory buildRequestFactory() {
        if (this.requestFactory != null) {
            return this.requestFactory.apply(this.requestFactorySettings);
        }
        if (this.detectRequestFactory) {
            return ClientHttpRequestFactories.get(this.requestFactorySettings);
        }
        return null;
    }

    private void addClientHttpRequestInitializer(RestTemplate restTemplate) {
        if (this.basicAuthentication == null && this.defaultHeaders.isEmpty() && this.requestCustomizers.isEmpty()) {
            return;
        }
        restTemplate.getHttpRequestInitializers().add(new RestTemplateBuilderClientHttpRequestInitializer(this.basicAuthentication, this.defaultHeaders, this.requestCustomizers));
    }

    private <T> Set<T> copiedSetOf(T ... items) {
        return this.copiedSetOf((Collection<? extends T>)Arrays.asList(items));
    }

    private <T> Set<T> copiedSetOf(Collection<? extends T> collection) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(collection));
    }

    private static <T> List<T> copiedListOf(T[] items) {
        return List.of(Arrays.copyOf(items, items.length));
    }

    private static <T> Set<T> append(@Nullable Collection<? extends T> collection, @Nullable Collection<? extends T> additions) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(collection != null ? collection : Collections.emptySet());
        if (additions != null) {
            result.addAll(additions);
        }
        return Collections.unmodifiableSet(result);
    }

    private static <K, V> Map<K, List<V>> append(@Nullable Map<K, List<V>> map, K key, @Nullable V[] values) {
        LinkedHashMap<K, List<List<V>>> result = new LinkedHashMap<K, List<List<V>>>(map != null ? map : Collections.emptyMap());
        if (values != null) {
            result.put(key, RestTemplateBuilder.copiedListOf(values));
        }
        return Collections.unmodifiableMap(result);
    }
}

