/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.config;

import infra.aot.hint.ExecutableMode;
import infra.aot.hint.ReflectionHints;
import infra.aot.hint.RuntimeHints;
import infra.aot.hint.RuntimeHintsRegistrar;
import infra.aot.hint.TypeReference;
import infra.http.client.ClientHttpRequestFactory;
import infra.http.client.ClientHttpRequestFactoryWrapper;
import infra.http.client.HttpComponentsClientHttpRequestFactory;
import infra.http.client.JdkClientHttpRequestFactory;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ClassUtils;
import infra.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.http.HttpClient;
import java.time.Duration;

class ClientHttpRequestFactoriesRuntimeHints
implements RuntimeHintsRegistrar {
    ClientHttpRequestFactoriesRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        if (ClassUtils.isPresent((String)"infra.http.client.ClientHttpRequestFactory", (ClassLoader)classLoader)) {
            this.registerHints(hints.reflection(), classLoader);
        }
    }

    private void registerHints(ReflectionHints hints, @Nullable ClassLoader classLoader) {
        hints.registerField(this.findField(ClientHttpRequestFactoryWrapper.class, "requestFactory"));
        hints.registerTypeIfPresent(classLoader, "org.apache.hc.client5.http.impl.classic.HttpClients", typeHint -> {
            typeHint.onReachableType(TypeReference.of((String)"org.apache.hc.client5.http.impl.classic.HttpClients"));
            this.registerReflectionHints(hints, HttpComponentsClientHttpRequestFactory.class);
        });
        hints.registerType(JdkClientHttpRequestFactory.class, typeHint -> {
            typeHint.onReachableType(HttpClient.class);
            this.registerReflectionHints(hints, JdkClientHttpRequestFactory.class, Duration.class);
        });
    }

    private void registerReflectionHints(ReflectionHints hints, Class<? extends ClientHttpRequestFactory> requestFactoryType) {
        this.registerReflectionHints(hints, requestFactoryType, Integer.TYPE);
    }

    private void registerReflectionHints(ReflectionHints hints, Class<? extends ClientHttpRequestFactory> requestFactoryType, Class<?> readTimeoutType) {
        this.registerMethod(hints, requestFactoryType, "setConnectTimeout", Integer.TYPE);
        this.registerMethod(hints, requestFactoryType, "setReadTimeout", readTimeoutType);
    }

    private void registerMethod(ReflectionHints hints, Class<? extends ClientHttpRequestFactory> requestFactoryType, String methodName, Class<?> ... parameterTypes) {
        Method method = ReflectionUtils.findMethod(requestFactoryType, (String)methodName, (Class[])parameterTypes);
        if (method != null) {
            hints.registerMethod(method, ExecutableMode.INVOKE);
        }
    }

    private Field findField(Class<?> type, String name) {
        Field field = ReflectionUtils.findField(type, (String)name);
        Assert.state((field != null ? 1 : 0) != 0, () -> "Unable to find field '%s' on %s".formatted(type.getName(), name));
        return field;
    }
}

