/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.config;

import infra.core.ssl.SslBundle;
import infra.core.ssl.SslOptions;
import infra.http.client.ClientHttpRequestFactory;
import infra.http.client.ClientHttpRequestFactoryWrapper;
import infra.http.client.HttpComponentsClientHttpRequestFactory;
import infra.http.client.JdkClientHttpRequestFactory;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ClassUtils;
import infra.util.PropertyMapper;
import infra.util.ReflectionUtils;
import infra.web.client.config.ClientHttpRequestFactorySettings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.io.SocketConfig;

public abstract class ClientHttpRequestFactories {
    static final String APACHE_HTTP_CLIENT_CLASS = "org.apache.hc.client5.http.impl.classic.HttpClients";
    private static final boolean APACHE_HTTP_CLIENT_PRESENT = ClassUtils.isPresent((String)"org.apache.hc.client5.http.impl.classic.HttpClients");

    public static ClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
        Assert.notNull((Object)settings, (String)"Settings is required");
        if (APACHE_HTTP_CLIENT_PRESENT) {
            return HttpComponents.get(settings);
        }
        return Jdk.get(settings);
    }

    public static <T extends ClientHttpRequestFactory> T get(Class<T> requestFactoryType, ClientHttpRequestFactorySettings settings) {
        Assert.notNull((Object)settings, (String)"Settings is required");
        if (requestFactoryType == ClientHttpRequestFactory.class) {
            return (T)ClientHttpRequestFactories.get(settings);
        }
        if (requestFactoryType == HttpComponentsClientHttpRequestFactory.class) {
            return (T)HttpComponents.get(settings);
        }
        if (requestFactoryType == JdkClientHttpRequestFactory.class) {
            return (T)Jdk.get(settings);
        }
        return (T)ClientHttpRequestFactories.get(() -> ClientHttpRequestFactories.createRequestFactory(requestFactoryType), settings);
    }

    public static <T extends ClientHttpRequestFactory> T get(Supplier<T> requestFactorySupplier, ClientHttpRequestFactorySettings settings) {
        return Reflective.get(requestFactorySupplier, settings);
    }

    private static <T extends ClientHttpRequestFactory> T createRequestFactory(Class<T> requestFactory) {
        try {
            Constructor<T> constructor = requestFactory.getDeclaredConstructor(new Class[0]);
            ReflectionUtils.makeAccessible(constructor);
            return (T)((ClientHttpRequestFactory)constructor.newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    static class HttpComponents {
        HttpComponents() {
        }

        static HttpComponentsClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
            HttpComponentsClientHttpRequestFactory requestFactory = HttpComponents.createRequestFactory(settings.readTimeout(), settings.sslBundle());
            if (settings.connectTimeout() != null) {
                requestFactory.setConnectTimeout((int)settings.connectTimeout().toMillis());
            }
            return requestFactory;
        }

        private static HttpComponentsClientHttpRequestFactory createRequestFactory(@Nullable Duration readTimeout, @Nullable SslBundle sslBundle) {
            return new HttpComponentsClientHttpRequestFactory(HttpComponents.createHttpClient(readTimeout, sslBundle));
        }

        private static org.apache.hc.client5.http.classic.HttpClient createHttpClient(@Nullable Duration readTimeout, @Nullable SslBundle sslBundle) {
            PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
            if (readTimeout != null) {
                SocketConfig socketConfig = SocketConfig.custom().setSoTimeout((int)readTimeout.toMillis(), TimeUnit.MILLISECONDS).build();
                connectionManagerBuilder.setDefaultSocketConfig(socketConfig);
            }
            if (sslBundle != null) {
                SslOptions options = sslBundle.getOptions();
                SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslBundle.createSslContext(), options.getEnabledProtocols(), options.getCiphers(), (HostnameVerifier)new DefaultHostnameVerifier());
                connectionManagerBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
            }
            PoolingHttpClientConnectionManager connectionManager = connectionManagerBuilder.useSystemProperties().build();
            return HttpClientBuilder.create().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
    }

    static class Jdk {
        Jdk() {
        }

        static JdkClientHttpRequestFactory get(ClientHttpRequestFactorySettings settings) {
            HttpClient httpClient = Jdk.createHttpClient(settings.connectTimeout(), settings.sslBundle());
            JdkClientHttpRequestFactory requestFactory = new JdkClientHttpRequestFactory(httpClient);
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(settings::readTimeout).to(requestFactory::setReadTimeout);
            return requestFactory;
        }

        private static HttpClient createHttpClient(@Nullable Duration connectTimeout, @Nullable SslBundle sslBundle) {
            HttpClient.Builder builder = HttpClient.newBuilder();
            if (connectTimeout != null) {
                builder.connectTimeout(connectTimeout);
            }
            if (sslBundle != null) {
                builder.sslContext(sslBundle.createSslContext());
            }
            return builder.build();
        }
    }

    static class Reflective {
        Reflective() {
        }

        static <T extends ClientHttpRequestFactory> T get(Supplier<T> supplier, ClientHttpRequestFactorySettings settings) {
            ClientHttpRequestFactory requestFactory = (ClientHttpRequestFactory)supplier.get();
            Reflective.configure(requestFactory, settings);
            return (T)requestFactory;
        }

        private static void configure(ClientHttpRequestFactory requestFactory, ClientHttpRequestFactorySettings settings) {
            ClientHttpRequestFactory unwrapped = Reflective.unwrapIfNecessary(requestFactory);
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(settings::readTimeout).to(readTimeout -> Reflective.setReadTimeout(unwrapped, readTimeout));
            map.from(settings::connectTimeout).to(connectTimeout -> Reflective.setConnectTimeout(unwrapped, connectTimeout));
            map.from(settings::bufferRequestBody).to(bufferRequestBody -> Reflective.setBufferRequestBody(unwrapped, bufferRequestBody));
        }

        private static ClientHttpRequestFactory unwrapIfNecessary(ClientHttpRequestFactory requestFactory) {
            if (requestFactory instanceof ClientHttpRequestFactoryWrapper) {
                while (requestFactory instanceof ClientHttpRequestFactoryWrapper) {
                    ClientHttpRequestFactoryWrapper wrapper = (ClientHttpRequestFactoryWrapper)requestFactory;
                    requestFactory = wrapper.getRequestFactory();
                }
            }
            return requestFactory;
        }

        private static void setConnectTimeout(ClientHttpRequestFactory factory, Duration connectTimeout) {
            Method method = Reflective.findMethod(factory, "setConnectTimeout", Integer.TYPE);
            int timeout = Math.toIntExact(connectTimeout.toMillis());
            Reflective.invoke(factory, method, timeout);
        }

        private static void setReadTimeout(ClientHttpRequestFactory factory, Duration readTimeout) {
            Method method = Reflective.findMethod(factory, "setReadTimeout", Integer.TYPE);
            int timeout = Math.toIntExact(readTimeout.toMillis());
            Reflective.invoke(factory, method, timeout);
        }

        private static void setBufferRequestBody(ClientHttpRequestFactory factory, boolean bufferRequestBody) {
            Method method = Reflective.findMethod(factory, "setBufferRequestBody", Boolean.TYPE);
            Reflective.invoke(factory, method, bufferRequestBody);
        }

        private static Method findMethod(ClientHttpRequestFactory requestFactory, String methodName, Class<?> ... parameters) {
            Method method = ReflectionUtils.findMethod(requestFactory.getClass(), (String)methodName, (Class[])parameters);
            Assert.state((method != null ? 1 : 0) != 0, () -> "Request factory %s does not have a suitable %s method".formatted(requestFactory.getClass().getName(), methodName));
            Assert.state((!method.isAnnotationPresent(Deprecated.class) ? 1 : 0) != 0, () -> "Request factory %s has the %s method marked as deprecated".formatted(requestFactory.getClass().getName(), methodName));
            return method;
        }

        private static void invoke(ClientHttpRequestFactory requestFactory, Method method, Object ... parameters) {
            ReflectionUtils.invokeMethod((Method)method, (Object)requestFactory, (Object[])parameters);
        }
    }
}

