/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client.config;

import infra.http.HttpHeaders;
import infra.lang.Assert;
import infra.lang.Nullable;
import java.nio.charset.Charset;

class BasicAuthentication {
    private final String username;
    private final String password;
    @Nullable
    private final Charset charset;

    BasicAuthentication(String username, String password, @Nullable Charset charset) {
        Assert.notNull((Object)username, (String)"Username is required");
        Assert.notNull((Object)password, (String)"Password is required");
        this.username = username;
        this.password = password;
        this.charset = charset;
    }

    void applyTo(HttpHeaders headers) {
        if (!headers.containsKey("Authorization")) {
            headers.setBasicAuth(this.username, this.password, this.charset);
        }
    }
}

