/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.lang.Nullable;
import infra.web.client.RestClientException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

public class UnknownContentTypeException
extends RestClientException {
    private final transient Type targetType;
    private final MediaType contentType;
    private final HttpStatusCode statusCode;
    private final String statusText;
    private final byte[] responseBody;
    private final HttpHeaders responseHeaders;

    public UnknownContentTypeException(Type targetType, MediaType contentType, int statusCode, String statusText, HttpHeaders responseHeaders, byte[] responseBody) {
        this(targetType, contentType, HttpStatusCode.valueOf(statusCode), statusText, responseHeaders, responseBody);
    }

    public UnknownContentTypeException(Type targetType, MediaType contentType, HttpStatusCode statusCode, String statusText, HttpHeaders responseHeaders, byte[] responseBody) {
        super("Could not extract response: no suitable HttpMessageConverter found for response type [%s] and content type [%s]".formatted(targetType, contentType));
        this.targetType = targetType;
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    public int getRawStatusCode() {
        return this.statusCode.value();
    }

    public String getStatusText() {
        return this.statusText;
    }

    @Nullable
    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }

    public String getResponseBodyAsString() {
        return new String(this.responseBody, this.contentType.getCharset() != null ? this.contentType.getCharset() : StandardCharsets.UTF_8);
    }
}

