/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.http.HttpRequest;
import infra.http.HttpStatusCode;
import infra.http.client.ClientHttpResponse;
import infra.http.converter.HttpMessageConverter;
import infra.lang.Assert;
import infra.web.client.DefaultResponseErrorHandler;
import infra.web.client.ResponseErrorHandler;
import infra.web.client.RestClient;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;

final class StatusHandler {
    StatusHandler() {
    }

    public static ResponseErrorHandler of(Predicate<HttpStatusCode> predicate, RestClient.ErrorHandler errorHandler) {
        Assert.notNull(predicate, (String)"Predicate is required");
        Assert.notNull((Object)errorHandler, (String)"ErrorHandler is required");
        return new FuncErrorHandler(predicate, errorHandler);
    }

    public static ResponseErrorHandler defaultHandler(List<HttpMessageConverter<?>> messageConverters) {
        DefaultResponseErrorHandler handler = new DefaultResponseErrorHandler();
        handler.setMessageConverters(messageConverters);
        return handler;
    }

    static final class FuncErrorHandler
    implements ResponseErrorHandler {
        private final Predicate<HttpStatusCode> predicate;
        private final RestClient.ErrorHandler errorHandler;

        FuncErrorHandler(Predicate<HttpStatusCode> predicate, RestClient.ErrorHandler errorHandler) {
            this.predicate = predicate;
            this.errorHandler = errorHandler;
        }

        @Override
        public boolean hasError(ClientHttpResponse response) throws IOException {
            return this.predicate.test(response.getStatusCode());
        }

        @Override
        public void handleError(HttpRequest request, ClientHttpResponse response) throws IOException {
            this.errorHandler.handle(request, response);
        }
    }
}

