/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.core.ParameterizedTypeReference;
import infra.http.HttpEntity;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpRequest;
import infra.http.MediaType;
import infra.http.RequestEntity;
import infra.http.ResponseEntity;
import infra.http.client.ClientHttpRequest;
import infra.http.client.ClientHttpRequestFactory;
import infra.http.client.ClientHttpResponse;
import infra.http.client.support.InterceptingHttpAccessor;
import infra.http.converter.AllEncompassingFormHttpMessageConverter;
import infra.http.converter.ByteArrayHttpMessageConverter;
import infra.http.converter.GenericHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.ResourceHttpMessageConverter;
import infra.http.converter.StringHttpMessageConverter;
import infra.http.converter.cbor.MappingJackson2CborHttpMessageConverter;
import infra.http.converter.feed.AtomFeedHttpMessageConverter;
import infra.http.converter.feed.RssChannelHttpMessageConverter;
import infra.http.converter.json.GsonHttpMessageConverter;
import infra.http.converter.json.JsonbHttpMessageConverter;
import infra.http.converter.json.MappingJackson2HttpMessageConverter;
import infra.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import infra.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import infra.http.converter.yaml.MappingJackson2YamlHttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ClassUtils;
import infra.util.MimeTypeUtils;
import infra.util.SmartList;
import infra.web.client.DefaultResponseErrorHandler;
import infra.web.client.HttpMessageConverterExtractor;
import infra.web.client.RequestCallback;
import infra.web.client.ResponseErrorHandler;
import infra.web.client.ResponseExtractor;
import infra.web.client.RestClientException;
import infra.web.client.RestOperations;
import infra.web.util.AbstractUriTemplateHandler;
import infra.web.util.DefaultUriBuilderFactory;
import infra.web.util.UriTemplateHandler;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RestTemplate
extends InterceptingHttpAccessor
implements RestOperations {
    private static final boolean gsonPresent = RestTemplate.isPresent("com.google.gson.Gson");
    private static final boolean jsonbPresent = RestTemplate.isPresent("jakarta.json.bind.Jsonb");
    private static final boolean romePresent = RestTemplate.isPresent("com.rometools.rome.feed.WireFeed");
    private static final boolean jackson2Present = RestTemplate.isPresent("com.fasterxml.jackson.databind.ObjectMapper") && RestTemplate.isPresent("com.fasterxml.jackson.core.JsonGenerator");
    private static final boolean jackson2SmilePresent = RestTemplate.isPresent("com.fasterxml.jackson.dataformat.smile.SmileFactory");
    private static final boolean jackson2CborPresent = RestTemplate.isPresent("com.fasterxml.jackson.dataformat.cbor.CBORFactory");
    private static final boolean jackson2XmlPresent = RestTemplate.isPresent("com.fasterxml.jackson.dataformat.xml.XmlMapper");
    private static final boolean jackson2YamlPresent = RestTemplate.isPresent("com.fasterxml.jackson.dataformat.yaml.YAMLFactory");
    private final List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private ResponseErrorHandler errorHandler = new DefaultResponseErrorHandler();
    private UriTemplateHandler uriTemplateHandler;
    private final ResponseExtractor<HttpHeaders> headersExtractor = new HeadersExtractor();

    public RestTemplate() {
        this.messageConverters.add(new ByteArrayHttpMessageConverter());
        this.messageConverters.add(new StringHttpMessageConverter());
        this.messageConverters.add(new ResourceHttpMessageConverter(false));
        this.messageConverters.add(new AllEncompassingFormHttpMessageConverter());
        if (romePresent) {
            this.messageConverters.add(new AtomFeedHttpMessageConverter());
            this.messageConverters.add(new RssChannelHttpMessageConverter());
        }
        if (jackson2XmlPresent) {
            this.messageConverters.add(new MappingJackson2XmlHttpMessageConverter());
        }
        if (jackson2Present) {
            this.messageConverters.add(new MappingJackson2HttpMessageConverter());
        } else if (gsonPresent) {
            this.messageConverters.add(new GsonHttpMessageConverter());
        } else if (jsonbPresent) {
            this.messageConverters.add(new JsonbHttpMessageConverter());
        }
        if (jackson2SmilePresent) {
            this.messageConverters.add(new MappingJackson2SmileHttpMessageConverter());
        }
        if (jackson2CborPresent) {
            this.messageConverters.add(new MappingJackson2CborHttpMessageConverter());
        }
        if (jackson2YamlPresent) {
            this.messageConverters.add(new MappingJackson2YamlHttpMessageConverter());
        }
        this.updateErrorHandlerConverters();
        this.uriTemplateHandler = RestTemplate.initUriTemplateHandler();
    }

    public RestTemplate(ClientHttpRequestFactory requestFactory) {
        this();
        this.setRequestFactory(requestFactory);
    }

    public RestTemplate(List<HttpMessageConverter<?>> messageConverters) {
        this.validateConverters(messageConverters);
        this.messageConverters.addAll(messageConverters);
        this.uriTemplateHandler = RestTemplate.initUriTemplateHandler();
        this.updateErrorHandlerConverters();
    }

    private void updateErrorHandlerConverters() {
        ResponseErrorHandler responseErrorHandler = this.errorHandler;
        if (responseErrorHandler instanceof DefaultResponseErrorHandler) {
            DefaultResponseErrorHandler handler = (DefaultResponseErrorHandler)responseErrorHandler;
            handler.setMessageConverters(this.messageConverters);
        }
    }

    private static DefaultUriBuilderFactory initUriTemplateHandler() {
        DefaultUriBuilderFactory uriFactory = new DefaultUriBuilderFactory();
        uriFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.URI_COMPONENT);
        return uriFactory;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.validateConverters(messageConverters);
        if (this.messageConverters != messageConverters) {
            this.messageConverters.clear();
            this.messageConverters.addAll(messageConverters);
        }
        this.updateErrorHandlerConverters();
    }

    private void validateConverters(List<HttpMessageConverter<?>> messageConverters) {
        Assert.notEmpty(messageConverters, (String)"At least one HttpMessageConverter is required");
        Assert.noNullElements(messageConverters, (String)"The HttpMessageConverter list must not contain null elements");
    }

    public List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, (String)"ResponseErrorHandler is required");
        this.errorHandler = errorHandler;
        this.updateErrorHandlerConverters();
    }

    public ResponseErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setDefaultUriVariables(Map<String, ?> uriVars) {
        if (this.uriTemplateHandler instanceof DefaultUriBuilderFactory) {
            ((DefaultUriBuilderFactory)this.uriTemplateHandler).setDefaultUriVariables(uriVars);
        } else {
            UriTemplateHandler uriTemplateHandler = this.uriTemplateHandler;
            if (uriTemplateHandler instanceof AbstractUriTemplateHandler) {
                AbstractUriTemplateHandler handler = (AbstractUriTemplateHandler)uriTemplateHandler;
                handler.setDefaultUriVariables(uriVars);
            } else {
                throw new IllegalArgumentException("This property is not supported with the configured UriTemplateHandler.");
            }
        }
    }

    public void setUriTemplateHandler(UriTemplateHandler handler) {
        Assert.notNull((Object)handler, (String)"UriTemplateHandler is required");
        this.uriTemplateHandler = handler;
    }

    public UriTemplateHandler getUriTemplateHandler() {
        return this.uriTemplateHandler;
    }

    @Override
    @Nullable
    public <T> T getForObject(String url, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters(), this.logger);
        return this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    @Nullable
    public <T> T getForObject(String url, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters(), this.logger);
        return this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    @Nullable
    public <T> T getForObject(URI url, Class<T> responseType) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters(), this.logger);
        return this.execute(url, HttpMethod.GET, requestCallback, responseExtractor);
    }

    @Override
    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return RestTemplate.nonNull(this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, uriVariables));
    }

    @Override
    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return RestTemplate.nonNull(this.execute(url, HttpMethod.GET, requestCallback, responseExtractor, uriVariables));
    }

    @Override
    public <T> ResponseEntity<T> getForEntity(URI url, Class<T> responseType) throws RestClientException {
        RequestCallback requestCallback = this.acceptHeaderRequestCallback(responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return RestTemplate.nonNull(this.execute(url, HttpMethod.GET, requestCallback, responseExtractor));
    }

    @Override
    public HttpHeaders headForHeaders(String url, Object ... uriVariables) throws RestClientException {
        return RestTemplate.nonNull(this.execute(url, HttpMethod.HEAD, null, this.headersExtractor(), uriVariables));
    }

    @Override
    public HttpHeaders headForHeaders(String url, Map<String, ?> uriVariables) throws RestClientException {
        return RestTemplate.nonNull(this.execute(url, HttpMethod.HEAD, null, this.headersExtractor(), uriVariables));
    }

    @Override
    public HttpHeaders headForHeaders(URI url) throws RestClientException {
        return RestTemplate.nonNull(this.execute(url, HttpMethod.HEAD, null, this.headersExtractor()));
    }

    @Override
    @Nullable
    public URI postForLocation(String url, @Nullable Object request, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request);
        HttpHeaders headers = this.execute(url, HttpMethod.POST, requestCallback, this.headersExtractor(), uriVariables);
        return headers != null ? headers.getLocation() : null;
    }

    @Override
    @Nullable
    public URI postForLocation(String url, @Nullable Object request, Map<String, ?> uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request);
        HttpHeaders headers = this.execute(url, HttpMethod.POST, requestCallback, this.headersExtractor(), uriVariables);
        return headers != null ? headers.getLocation() : null;
    }

    @Override
    @Nullable
    public URI postForLocation(URI url, @Nullable Object request) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request);
        HttpHeaders headers = this.execute(url, HttpMethod.POST, requestCallback, this.headersExtractor());
        return headers != null ? headers.getLocation() : null;
    }

    @Override
    @Nullable
    public <T> T postForObject(String url, @Nullable Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters(), this.logger);
        return this.execute(url, HttpMethod.POST, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    @Nullable
    public <T> T postForObject(String url, @Nullable Object request, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters(), this.logger);
        return this.execute(url, HttpMethod.POST, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    @Nullable
    public <T> T postForObject(URI url, @Nullable Object request, Class<T> responseType) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor<T> responseExtractor = new HttpMessageConverterExtractor<T>(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.POST, requestCallback, responseExtractor);
    }

    @Override
    public <T> ResponseEntity<T> postForEntity(String url, @Nullable Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return RestTemplate.nonNull(this.execute(url, HttpMethod.POST, requestCallback, responseExtractor, uriVariables));
    }

    @Override
    public <T> ResponseEntity<T> postForEntity(String url, @Nullable Object request, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return RestTemplate.nonNull(this.execute(url, HttpMethod.POST, requestCallback, responseExtractor, uriVariables));
    }

    @Override
    public <T> ResponseEntity<T> postForEntity(URI url, @Nullable Object request, Class<T> responseType) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return RestTemplate.nonNull(this.execute(url, HttpMethod.POST, requestCallback, responseExtractor));
    }

    @Override
    public void put(String url, @Nullable Object request, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request);
        this.execute(url, HttpMethod.PUT, requestCallback, null, uriVariables);
    }

    @Override
    public void put(String url, @Nullable Object request, Map<String, ?> uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request);
        this.execute(url, HttpMethod.PUT, requestCallback, null, uriVariables);
    }

    @Override
    public void put(URI url, @Nullable Object request) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request);
        this.execute(url, HttpMethod.PUT, requestCallback, null);
    }

    @Override
    @Nullable
    public <T> T patchForObject(String url, @Nullable Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters(), this.logger);
        return this.execute(url, HttpMethod.PATCH, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    @Nullable
    public <T> T patchForObject(String url, @Nullable Object request, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor responseExtractor = new HttpMessageConverterExtractor(responseType, this.getMessageConverters(), this.logger);
        return this.execute(url, HttpMethod.PATCH, requestCallback, responseExtractor, uriVariables);
    }

    @Override
    @Nullable
    public <T> T patchForObject(URI url, @Nullable Object request, Class<T> responseType) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(request, responseType);
        HttpMessageConverterExtractor<T> responseExtractor = new HttpMessageConverterExtractor<T>(responseType, this.getMessageConverters());
        return this.execute(url, HttpMethod.PATCH, requestCallback, responseExtractor);
    }

    @Override
    public void delete(String url, Object ... uriVariables) throws RestClientException {
        this.execute(url, HttpMethod.DELETE, null, null, uriVariables);
    }

    @Override
    public void delete(String url, Map<String, ?> uriVariables) throws RestClientException {
        this.execute(url, HttpMethod.DELETE, null, null, uriVariables);
    }

    @Override
    public void delete(URI url) throws RestClientException {
        this.execute(url, HttpMethod.DELETE, null, null);
    }

    @Override
    public Set<HttpMethod> optionsForAllow(String url, Object ... uriVariables) throws RestClientException {
        ResponseExtractor<HttpHeaders> headersExtractor = this.headersExtractor();
        HttpHeaders headers = this.execute(url, HttpMethod.OPTIONS, null, headersExtractor, uriVariables);
        return headers != null ? headers.getAllow() : Collections.emptySet();
    }

    @Override
    public Set<HttpMethod> optionsForAllow(String url, Map<String, ?> uriVariables) throws RestClientException {
        ResponseExtractor<HttpHeaders> headersExtractor = this.headersExtractor();
        HttpHeaders headers = this.execute(url, HttpMethod.OPTIONS, null, headersExtractor, uriVariables);
        return headers != null ? headers.getAllow() : Collections.emptySet();
    }

    @Override
    public Set<HttpMethod> optionsForAllow(URI url) throws RestClientException {
        ResponseExtractor<HttpHeaders> headersExtractor = this.headersExtractor();
        HttpHeaders headers = this.execute(url, HttpMethod.OPTIONS, null, headersExtractor);
        return headers != null ? headers.getAllow() : Collections.emptySet();
    }

    @Override
    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(requestEntity, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return RestTemplate.nonNull(this.execute(url, method, requestCallback, responseExtractor, uriVariables));
    }

    @Override
    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(requestEntity, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return RestTemplate.nonNull(this.execute(url, method, requestCallback, responseExtractor, uriVariables));
    }

    @Override
    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, Class<T> responseType) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(requestEntity, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return RestTemplate.nonNull(this.execute(url, method, requestCallback, responseExtractor));
    }

    @Override
    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Object ... uriVariables) throws RestClientException {
        Type type = responseType.getType();
        RequestCallback requestCallback = this.httpEntityCallback(requestEntity, type);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(type);
        return RestTemplate.nonNull(this.execute(url, method, requestCallback, responseExtractor, uriVariables));
    }

    @Override
    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        Type type = responseType.getType();
        RequestCallback requestCallback = this.httpEntityCallback(requestEntity, type);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(type);
        return RestTemplate.nonNull(this.execute(url, method, requestCallback, responseExtractor, uriVariables));
    }

    @Override
    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, @Nullable HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) throws RestClientException {
        Type type = responseType.getType();
        RequestCallback requestCallback = this.httpEntityCallback(requestEntity, type);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(type);
        return RestTemplate.nonNull(this.execute(url, method, requestCallback, responseExtractor));
    }

    @Override
    public <T> ResponseEntity<T> exchange(RequestEntity<?> entity, Class<T> responseType) throws RestClientException {
        RequestCallback requestCallback = this.httpEntityCallback(entity, responseType);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(responseType);
        return RestTemplate.nonNull(this.doExecute(this.resolveUrl(entity), entity.getMethod(), requestCallback, responseExtractor));
    }

    @Override
    public <T> ResponseEntity<T> exchange(RequestEntity<?> entity, ParameterizedTypeReference<T> responseType) throws RestClientException {
        Type type = responseType.getType();
        RequestCallback requestCallback = this.httpEntityCallback(entity, type);
        ResponseExtractor<ResponseEntity<T>> responseExtractor = this.responseEntityExtractor(type);
        return RestTemplate.nonNull(this.doExecute(this.resolveUrl(entity), entity.getMethod(), requestCallback, responseExtractor));
    }

    private URI resolveUrl(RequestEntity<?> entity) {
        if (entity instanceof RequestEntity.UriTemplateRequestEntity) {
            RequestEntity.UriTemplateRequestEntity ext = (RequestEntity.UriTemplateRequestEntity)entity;
            if (ext.getVars() != null) {
                return this.uriTemplateHandler.expand(ext.getUriTemplate(), ext.getVars());
            }
            if (ext.getVarsMap() != null) {
                return this.uriTemplateHandler.expand(ext.getUriTemplate(), ext.getVarsMap());
            }
            throw new IllegalStateException("No variables specified for URI template: " + ext.getUriTemplate());
        }
        return entity.getUrl();
    }

    @Override
    @Nullable
    public <T> T execute(String url, HttpMethod method, @Nullable RequestCallback requestCallback, @Nullable ResponseExtractor<T> responseExtractor, Object ... uriVariables) throws RestClientException {
        URI expanded = this.getUriTemplateHandler().expand(url, uriVariables);
        return this.doExecute(expanded, method, requestCallback, responseExtractor);
    }

    @Override
    @Nullable
    public <T> T execute(String url, HttpMethod method, @Nullable RequestCallback requestCallback, @Nullable ResponseExtractor<T> responseExtractor, Map<String, ?> uriVariables) throws RestClientException {
        URI expanded = this.getUriTemplateHandler().expand(url, uriVariables);
        return this.doExecute(expanded, method, requestCallback, responseExtractor);
    }

    @Override
    @Nullable
    public <T> T execute(URI url, HttpMethod method, @Nullable RequestCallback requestCallback, @Nullable ResponseExtractor<T> responseExtractor) throws RestClientException {
        return this.doExecute(url, method, requestCallback, responseExtractor);
    }

    @Nullable
    protected <T> T doExecute(URI url, @Nullable HttpMethod method, @Nullable RequestCallback requestCallback, @Nullable ResponseExtractor<T> responseExtractor) throws RestClientException {
        Assert.notNull((Object)url, (String)"URI is required");
        Assert.notNull((Object)((Object)method), (String)"HttpMethod is required");
        try (ClientHttpResponse response = null;){
            ClientHttpRequest request = this.createRequest(url, method);
            if (requestCallback != null) {
                requestCallback.doWithRequest(request);
            }
            response = request.execute();
            this.handleResponse(request, response);
            T t = responseExtractor != null ? (T)responseExtractor.extractData(response) : null;
            return t;
        }
    }

    protected void handleResponse(HttpRequest request, ClientHttpResponse response) throws IOException {
        ResponseErrorHandler errorHandler = this.getErrorHandler();
        boolean hasError = errorHandler.hasError(response);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} Response {}", (Object)request.getURI(), (Object)response.getStatusCode());
        }
        if (hasError) {
            errorHandler.handleError(request, response);
        }
    }

    public <T> RequestCallback acceptHeaderRequestCallback(Class<T> responseType) {
        return new AcceptHeaderRequestCallback(responseType);
    }

    public RequestCallback httpEntityCallback(@Nullable Object requestBody) {
        return new HttpEntityRequestCallback(requestBody);
    }

    public RequestCallback httpEntityCallback(@Nullable Object requestBody, Type responseType) {
        return new HttpEntityRequestCallback(requestBody, responseType);
    }

    public <T> ResponseExtractor<ResponseEntity<T>> responseEntityExtractor(Type responseType) {
        return new ResponseEntityResponseExtractor(responseType);
    }

    protected ResponseExtractor<HttpHeaders> headersExtractor() {
        return this.headersExtractor;
    }

    private static <T> T nonNull(@Nullable T result) {
        Assert.state((result != null ? 1 : 0) != 0, (String)"No result");
        return result;
    }

    static boolean isPresent(String name) {
        ClassLoader classLoader = RestTemplate.class.getClassLoader();
        return ClassUtils.isPresent((String)name, (ClassLoader)classLoader);
    }

    private static void copyHttpHeaders(HttpHeaders httpHeaders, HttpHeaders requestHeaders) {
        if (!requestHeaders.isEmpty()) {
            for (Map.Entry entry : requestHeaders.entrySet()) {
                httpHeaders.put((String)entry.getKey(), new SmartList((Collection)entry.getValue()));
            }
        }
    }

    private static class HeadersExtractor
    implements ResponseExtractor<HttpHeaders> {
        private HeadersExtractor() {
        }

        @Override
        public HttpHeaders extractData(ClientHttpResponse response) {
            return response.getHeaders();
        }
    }

    private class AcceptHeaderRequestCallback
    implements RequestCallback {
        @Nullable
        private final Type responseType;

        public AcceptHeaderRequestCallback(Type responseType) {
            this.responseType = responseType;
        }

        @Override
        public void doWithRequest(ClientHttpRequest request) throws IOException {
            if (this.responseType != null) {
                HashSet<MediaType> allSupportedMediaTypes = new HashSet<MediaType>();
                for (HttpMessageConverter<?> converter : RestTemplate.this.getMessageConverters()) {
                    if (!this.canReadResponse(this.responseType, converter)) continue;
                    this.putSupportedMediaTypes(this.responseType, converter, allSupportedMediaTypes);
                }
                ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>(allSupportedMediaTypes);
                MimeTypeUtils.sortBySpecificity(supportedMediaTypes);
                if (RestTemplate.this.logger.isDebugEnabled()) {
                    RestTemplate.this.logger.debug("Accept={}", allSupportedMediaTypes);
                }
                request.getHeaders().setAccept(supportedMediaTypes);
            }
        }

        private boolean canReadResponse(Type responseType, HttpMessageConverter<?> converter) {
            Class responseClass;
            Class clazz = responseClass = responseType instanceof Class ? (Class)responseType : null;
            if (responseClass != null) {
                return converter.canRead(responseClass, null);
            }
            if (converter instanceof GenericHttpMessageConverter) {
                GenericHttpMessageConverter genericConverter = (GenericHttpMessageConverter)converter;
                return genericConverter.canRead(responseType, null, null);
            }
            return false;
        }

        private void putSupportedMediaTypes(Type type, HttpMessageConverter<?> converter, HashSet<MediaType> allSupportedMediaTypes) {
            List<MediaType> mediaTypes;
            Type type2;
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterized = (ParameterizedType)type;
                type2 = parameterized.getRawType();
            } else {
                type2 = type;
            }
            Type rawType = type2;
            Class clazz = rawType instanceof Class ? (Class)rawType : null;
            List<MediaType> list = mediaTypes = clazz != null ? converter.getSupportedMediaTypes(clazz) : converter.getSupportedMediaTypes();
            if (!mediaTypes.isEmpty()) {
                for (MediaType mediaType : mediaTypes) {
                    if (mediaType.getCharset() != null) {
                        mediaType = new MediaType(mediaType.getType(), mediaType.getSubtype());
                    }
                    allSupportedMediaTypes.add(mediaType);
                }
            }
        }
    }

    private class HttpEntityRequestCallback
    extends AcceptHeaderRequestCallback {
        private final HttpEntity<?> requestEntity;

        public HttpEntityRequestCallback(Object requestBody) {
            this(requestBody, null);
        }

        public HttpEntityRequestCallback(@Nullable Object requestBody, Type responseType) {
            super(responseType);
            this.requestEntity = requestBody instanceof HttpEntity ? (HttpEntity<Object>)requestBody : (requestBody != null ? new HttpEntity<Object>(requestBody) : HttpEntity.EMPTY);
        }

        @Override
        public void doWithRequest(ClientHttpRequest httpRequest) throws IOException {
            super.doWithRequest(httpRequest);
            Object requestBody = this.requestEntity.getBody();
            if (requestBody == null) {
                HttpHeaders httpHeaders = httpRequest.getHeaders();
                RestTemplate.copyHttpHeaders(httpHeaders, this.requestEntity.getHeaders());
                if (httpHeaders.getContentLength() < 0L) {
                    httpHeaders.setContentLength(0L);
                }
            } else {
                Type type;
                Class<?> requestBodyClass = requestBody.getClass();
                HttpEntity<?> httpEntity = this.requestEntity;
                if (httpEntity instanceof RequestEntity) {
                    RequestEntity entity = (RequestEntity)httpEntity;
                    type = entity.getType();
                } else {
                    type = requestBodyClass;
                }
                Class<?> requestBodyType = type;
                HttpHeaders httpHeaders = httpRequest.getHeaders();
                HttpHeaders requestHeaders = this.requestEntity.getHeaders();
                MediaType requestContentType = requestHeaders.getContentType();
                for (HttpMessageConverter<?> messageConverter : RestTemplate.this.getMessageConverters()) {
                    if (messageConverter instanceof GenericHttpMessageConverter) {
                        GenericHttpMessageConverter genericConverter = (GenericHttpMessageConverter)messageConverter;
                        if (!genericConverter.canWrite(requestBodyType, requestBodyClass, requestContentType)) continue;
                        RestTemplate.copyHttpHeaders(httpHeaders, requestHeaders);
                        if (RestTemplate.this.logger.isDebugEnabled()) {
                            this.logBody(requestBody, requestContentType, genericConverter);
                        }
                        genericConverter.write(requestBody, requestBodyType, requestContentType, httpRequest);
                        return;
                    }
                    if (!messageConverter.canWrite(requestBodyClass, requestContentType)) continue;
                    RestTemplate.copyHttpHeaders(httpHeaders, requestHeaders);
                    if (RestTemplate.this.logger.isDebugEnabled()) {
                        this.logBody(requestBody, requestContentType, messageConverter);
                    }
                    messageConverter.write(requestBody, requestContentType, httpRequest);
                    return;
                }
                String message = "No HttpMessageConverter for " + requestBodyClass.getName();
                if (requestContentType != null) {
                    message = message + " and content type \"%s\"".formatted(requestContentType);
                }
                throw new RestClientException(message);
            }
        }

        private void logBody(Object body, @Nullable MediaType mediaType, HttpMessageConverter<?> converter) {
            if (mediaType != null) {
                RestTemplate.this.logger.debug("Writing [{}] as \"{}\"", body, (Object)mediaType);
            } else {
                RestTemplate.this.logger.debug("Writing [{}] with {}", body, (Object)converter.getClass().getName());
            }
        }
    }

    private class ResponseEntityResponseExtractor<T>
    implements ResponseExtractor<ResponseEntity<T>> {
        @Nullable
        private final HttpMessageConverterExtractor<T> delegate;

        public ResponseEntityResponseExtractor(Type responseType) {
            this.delegate = responseType != null && Void.class != responseType ? new HttpMessageConverterExtractor(responseType, RestTemplate.this.getMessageConverters(), RestTemplate.this.logger) : null;
        }

        @Override
        public ResponseEntity<T> extractData(ClientHttpResponse response) throws IOException {
            if (this.delegate != null) {
                T body = this.delegate.extractData(response);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status(response.getStatusCode()).headers(response.getHeaders())).body(body);
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status(response.getStatusCode()).headers(response.getHeaders())).build();
        }
    }
}

