/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.http.HttpHeaders;
import infra.http.HttpInputMessage;
import infra.http.HttpMessage;
import infra.http.MediaType;
import infra.lang.Nullable;
import infra.util.FileCopyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

abstract class RestClientUtils {
    RestClientUtils() {
    }

    public static byte[] getBody(HttpInputMessage message) {
        try {
            return FileCopyUtils.copyToByteArray((InputStream)message.getBody());
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    @Nullable
    public static Charset getCharset(HttpMessage response) {
        HttpHeaders headers = response.getHeaders();
        MediaType contentType = headers.getContentType();
        return contentType != null ? contentType.getCharset() : null;
    }
}

