/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.core.ParameterizedTypeReference;
import infra.core.ResolvableType;
import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.web.client.RestClientException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.function.Function;

public class RestClientResponseException
extends RestClientException {
    private final HttpStatusCode statusCode;
    private final String statusText;
    private final byte[] responseBody;
    @Nullable
    private final HttpHeaders responseHeaders;
    @Nullable
    private final transient Charset responseCharset;
    @Nullable
    private transient Function<ResolvableType, ?> bodyConvertFunction;

    public RestClientResponseException(@Nullable String message, int statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] responseBody, @Nullable Charset responseCharset) {
        this(message, HttpStatusCode.valueOf(statusCode), statusText, headers, responseBody, responseCharset);
    }

    public RestClientResponseException(@Nullable String message, HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] responseBody, @Nullable Charset responseCharset) {
        super(message);
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.responseHeaders = headers;
        this.responseBody = responseBody != null ? responseBody : Constant.EMPTY_BYTES;
        this.responseCharset = responseCharset;
    }

    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    public int getRawStatusCode() {
        return this.statusCode.value();
    }

    public String getStatusText() {
        return this.statusText;
    }

    @Nullable
    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public byte[] getResponseBodyAsByteArray() {
        return this.responseBody;
    }

    public String getResponseBodyAsString() {
        return this.getResponseBodyAsString(Constant.DEFAULT_CHARSET);
    }

    public String getResponseBodyAsString(Charset fallbackCharset) {
        Charset charsetToUse = this.responseCharset;
        if (charsetToUse == null) {
            charsetToUse = fallbackCharset;
        }
        return new String(this.responseBody, charsetToUse);
    }

    @Nullable
    public <E> E getResponseBodyAs(Class<E> targetType) {
        return this.getResponseBodyAs(ResolvableType.forClass(targetType));
    }

    @Nullable
    public <E> E getResponseBodyAs(ParameterizedTypeReference<E> targetType) {
        return this.getResponseBodyAs(ResolvableType.forType((Type)targetType.getType()));
    }

    @Nullable
    private <E> E getResponseBodyAs(ResolvableType targetType) {
        Assert.state((this.bodyConvertFunction != null ? 1 : 0) != 0, (String)"Function to convert body not set");
        return (E)this.bodyConvertFunction.apply(targetType);
    }

    public void setBodyConvertFunction(Function<ResolvableType, ?> bodyConvertFunction) {
        this.bodyConvertFunction = bodyConvertFunction;
    }
}

