/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.core.ParameterizedTypeReference;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpRequest;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.http.ResponseEntity;
import infra.http.StreamingHttpOutputMessage;
import infra.http.client.ClientHttpRequest;
import infra.http.client.ClientHttpRequestFactory;
import infra.http.client.ClientHttpRequestInitializer;
import infra.http.client.ClientHttpRequestInterceptor;
import infra.http.client.ClientHttpResponse;
import infra.http.converter.HttpMessageConverter;
import infra.lang.CheckReturnValue;
import infra.lang.Nullable;
import infra.util.MultiValueMap;
import infra.util.concurrent.Future;
import infra.web.client.ClientResponse;
import infra.web.client.DefaultRestClientBuilder;
import infra.web.client.ResponseErrorHandler;
import infra.web.client.RestTemplate;
import infra.web.util.UriBuilder;
import infra.web.util.UriBuilderFactory;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface RestClient {
    public RequestHeadersUriSpec<?> get();

    default public RequestHeadersSpec<?> get(URI uri) {
        return this.get().uri(uri);
    }

    default public RequestHeadersSpec<?> get(String uri, Object ... uriVariables) {
        return this.get().uri(uri, uriVariables);
    }

    public RequestHeadersUriSpec<?> head();

    public RequestBodyUriSpec post();

    public RequestBodyUriSpec put();

    public RequestBodyUriSpec patch();

    public RequestBodyUriSpec delete();

    public RequestHeadersUriSpec<?> options();

    public RequestBodyUriSpec method(HttpMethod var1);

    public Builder mutate();

    public static RestClient create() {
        return new DefaultRestClientBuilder().build();
    }

    public static RestClient create(String baseURI) {
        return new DefaultRestClientBuilder().baseURI(baseURI).build();
    }

    public static RestClient create(URI baseURI) {
        return new DefaultRestClientBuilder().baseURI(baseURI).build();
    }

    public static RestClient create(RestTemplate restTemplate) {
        return new DefaultRestClientBuilder(restTemplate).build();
    }

    public static Builder builder() {
        return new DefaultRestClientBuilder();
    }

    public static Builder builder(RestTemplate restTemplate) {
        return new DefaultRestClientBuilder(restTemplate);
    }

    public static interface RequestHeadersUriSpec<S extends RequestHeadersSpec<S>>
    extends UriSpec<S>,
    RequestHeadersSpec<S> {
    }

    public static interface RequestHeadersSpec<S extends RequestHeadersSpec<S>> {
        public S accept(MediaType ... var1);

        public S acceptCharset(Charset ... var1);

        public S ifModifiedSince(ZonedDateTime var1);

        public S ifNoneMatch(String ... var1);

        public S header(String var1, String ... var2);

        public S headers(Consumer<HttpHeaders> var1);

        public S headers(@Nullable HttpHeaders var1);

        public S cookie(String var1, String var2);

        public S cookies(Consumer<MultiValueMap<String, String>> var1);

        public S cookies(MultiValueMap<String, String> var1);

        public S attribute(String var1, Object var2);

        public S attributes(Consumer<Map<String, Object>> var1);

        public S attributes(@Nullable Map<String, Object> var1);

        public S httpRequest(Consumer<ClientHttpRequest> var1);

        @CheckReturnValue
        public ResponseSpec retrieve();

        default public AsyncSpec async() {
            return this.async(null);
        }

        public AsyncSpec async(@Nullable Executor var1);

        default public Future<ClientResponse> send() {
            return this.send(null);
        }

        public Future<ClientResponse> send(@Nullable Executor var1);

        default public ClientResponse execute() {
            return this.execute(true);
        }

        public ClientResponse execute(boolean var1);

        default public <T> T exchange(ExchangeFunction<T> exchangeFunction) {
            return this.exchange(exchangeFunction, true);
        }

        public <T> T exchange(ExchangeFunction<T> var1, boolean var2);

        @FunctionalInterface
        public static interface ExchangeFunction<T> {
            public T exchange(HttpRequest var1, ClientResponse var2) throws IOException;
        }
    }

    public static interface Builder {
        public Builder baseURI(@Nullable String var1);

        public Builder baseURI(@Nullable URI var1);

        public Builder defaultUriVariables(@Nullable Map<String, ?> var1);

        public Builder uriBuilderFactory(@Nullable UriBuilderFactory var1);

        public Builder defaultHeader(String var1, String ... var2);

        public Builder defaultHeaders(Consumer<HttpHeaders> var1);

        public Builder defaultHeaders(HttpHeaders var1);

        public Builder defaultCookie(String var1, String ... var2);

        public Builder defaultCookies(Consumer<MultiValueMap<String, String>> var1);

        public Builder defaultCookies(MultiValueMap<String, String> var1);

        public Builder defaultRequest(Consumer<RequestHeadersSpec<?>> var1);

        public Builder defaultStatusHandler(Predicate<HttpStatusCode> var1, ErrorHandler var2);

        public Builder defaultStatusHandler(ResponseErrorHandler var1);

        default public Builder ignoreStatus() {
            return this.ignoreStatus(true);
        }

        public Builder ignoreStatus(boolean var1);

        public Builder requestInterceptor(ClientHttpRequestInterceptor var1);

        public Builder requestInterceptors(Consumer<List<ClientHttpRequestInterceptor>> var1);

        public Builder requestInitializer(ClientHttpRequestInitializer var1);

        public Builder requestInitializers(Consumer<List<ClientHttpRequestInitializer>> var1);

        public Builder requestFactory(ClientHttpRequestFactory var1);

        public Builder messageConverters(Consumer<List<HttpMessageConverter<?>>> var1);

        public Builder messageConverters(List<HttpMessageConverter<?>> var1);

        public Builder apply(Consumer<Builder> var1);

        public Builder clone();

        public RestClient build();
    }

    public static interface RequestBodyUriSpec
    extends RequestBodySpec,
    RequestHeadersUriSpec<RequestBodySpec> {
    }

    @FunctionalInterface
    public static interface ErrorHandler {
        public void handle(HttpRequest var1, ClientHttpResponse var2) throws IOException;
    }

    public static interface AsyncSpec {
        public AsyncSpec onStatus(Predicate<HttpStatusCode> var1, ErrorHandler var2);

        public AsyncSpec onStatus(ResponseErrorHandler var1);

        default public AsyncSpec ignoreStatus() {
            return this.ignoreStatus(true);
        }

        public AsyncSpec ignoreStatus(boolean var1);

        public <T> Future<T> body(Class<T> var1);

        public <T> Future<T> body(ParameterizedTypeReference<T> var1);

        public <T> Future<ResponseEntity<T>> toEntity(Class<T> var1);

        public <T> Future<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> var1);

        public Future<ResponseEntity<Void>> toBodilessEntity();
    }

    public static interface ResponseSpec {
        public ResponseSpec onStatus(Predicate<HttpStatusCode> var1, ErrorHandler var2);

        public ResponseSpec onStatus(ResponseErrorHandler var1);

        default public ResponseSpec ignoreStatus() {
            return this.ignoreStatus(true);
        }

        public ResponseSpec ignoreStatus(boolean var1);

        @Nullable
        public <T> T body(Class<T> var1);

        @Nullable
        public <T> T body(ParameterizedTypeReference<T> var1);

        public <T> ResponseEntity<T> toEntity(Class<T> var1);

        public <T> ResponseEntity<T> toEntity(ParameterizedTypeReference<T> var1);

        public ResponseEntity<Void> toBodilessEntity();
    }

    public static interface RequestBodySpec
    extends RequestHeadersSpec<RequestBodySpec> {
        public RequestBodySpec contentLength(long var1);

        public RequestBodySpec contentType(MediaType var1);

        public RequestBodySpec body(Object var1);

        public <T> RequestBodySpec body(T var1, ParameterizedTypeReference<T> var2);

        public RequestBodySpec body(StreamingHttpOutputMessage.Body var1);
    }

    public static interface UriSpec<S extends RequestHeadersSpec<?>> {
        public S uri(URI var1);

        public S uri(String var1, Object ... var2);

        public S uri(String var1, Map<String, ?> var2);

        public S uri(String var1, Function<UriBuilder, URI> var2);

        public S uri(Function<UriBuilder, URI> var1);
    }
}

