/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.http.client.ClientHttpResponse;
import infra.http.client.ClientHttpResponseDecorator;
import infra.lang.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

class IntrospectingClientHttpResponse
extends ClientHttpResponseDecorator
implements ClientHttpResponse {
    @Nullable
    private PushbackInputStream pushbackInputStream;

    public IntrospectingClientHttpResponse(ClientHttpResponse response) {
        super(response);
    }

    public boolean hasMessageBody() throws IOException {
        HttpStatusCode statusCode = this.getStatusCode();
        if (statusCode.is1xxInformational() || statusCode == HttpStatus.NO_CONTENT || statusCode == HttpStatus.NOT_MODIFIED) {
            return false;
        }
        return this.getHeaders().getContentLength() != 0L;
    }

    public boolean hasEmptyMessageBody() throws IOException {
        InputStream body = this.delegate.getBody();
        if (body == null) {
            return true;
        }
        if (body.markSupported()) {
            body.mark(1);
            if (body.read() == -1) {
                return true;
            }
            body.reset();
            return false;
        }
        this.pushbackInputStream = new PushbackInputStream(body);
        int b = this.pushbackInputStream.read();
        if (b == -1) {
            return true;
        }
        this.pushbackInputStream.unread(b);
        return false;
    }

    @Override
    public InputStream getBody() throws IOException {
        return this.pushbackInputStream != null ? this.pushbackInputStream : super.getBody();
    }
}

