/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.client.RestClientResponseException;
import java.nio.charset.Charset;

public abstract class HttpStatusCodeException
extends RestClientResponseException {
    protected HttpStatusCodeException(HttpStatusCode statusCode) {
        this(statusCode, HttpStatusCodeException.name(statusCode), null, null, null);
    }

    private static String name(HttpStatusCode statusCode) {
        if (statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            return status.name();
        }
        return "";
    }

    protected HttpStatusCodeException(HttpStatusCode statusCode, String statusText) {
        this(statusCode, statusText, null, null, null);
    }

    protected HttpStatusCodeException(HttpStatusCode statusCode, String statusText, @Nullable byte[] responseBody, @Nullable Charset responseCharset) {
        this(statusCode, statusText, null, responseBody, responseCharset);
    }

    protected HttpStatusCodeException(HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders responseHeaders, @Nullable byte[] responseBody, @Nullable Charset responseCharset) {
        this(HttpStatusCodeException.getMessage(statusCode, statusText), statusCode, statusText, responseHeaders, responseBody, responseCharset);
    }

    protected HttpStatusCodeException(@Nullable String message, HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders responseHeaders, @Nullable byte[] responseBody, @Nullable Charset responseCharset) {
        super(message == null ? HttpStatusCodeException.getMessage(statusCode, statusText) : message, statusCode, statusText, responseHeaders, responseBody, responseCharset);
    }

    private static String getMessage(HttpStatusCode statusCode, String statusText) {
        if (StringUtils.isEmpty((CharSequence)statusText) && statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            statusText = status.getReasonPhrase();
        }
        return statusCode.value() + " " + statusText;
    }
}

