/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.lang.Nullable;
import infra.web.client.HttpStatusCodeException;
import java.nio.charset.Charset;

public class HttpServerErrorException
extends HttpStatusCodeException {
    public HttpServerErrorException(HttpStatusCode statusCode) {
        super(statusCode);
    }

    public HttpServerErrorException(HttpStatusCode statusCode, String statusText) {
        super(statusCode, statusText);
    }

    public HttpServerErrorException(HttpStatusCode statusCode, String statusText, @Nullable byte[] body, @Nullable Charset charset) {
        super(statusCode, statusText, body, charset);
    }

    public HttpServerErrorException(HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] body, @Nullable Charset charset) {
        super(statusCode, statusText, headers, body, charset);
    }

    public HttpServerErrorException(@Nullable String message, HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] body, @Nullable Charset charset) {
        super(message, statusCode, statusText, headers, body, charset);
    }

    public static HttpServerErrorException create(HttpStatus statusCode, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
        return HttpServerErrorException.create(null, statusCode, statusText, headers, body, charset);
    }

    public static HttpServerErrorException create(@Nullable String message, HttpStatusCode statusCode, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
        if (statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            return switch (status) {
                case HttpStatus.INTERNAL_SERVER_ERROR -> new InternalServerError(message, statusText, headers, body, charset);
                case HttpStatus.NOT_IMPLEMENTED -> new NotImplemented(message, statusText, headers, body, charset);
                case HttpStatus.BAD_GATEWAY -> new BadGateway(message, statusText, headers, body, charset);
                case HttpStatus.SERVICE_UNAVAILABLE -> new ServiceUnavailable(message, statusText, headers, body, charset);
                case HttpStatus.GATEWAY_TIMEOUT -> new GatewayTimeout(message, statusText, headers, body, charset);
                default -> new HttpServerErrorException(message, statusCode, statusText, headers, body, charset);
            };
        }
        if (message != null) {
            return new HttpServerErrorException(message, statusCode, statusText, headers, body, charset);
        }
        return new HttpServerErrorException(statusCode, statusText, headers, body, charset);
    }

    public static final class InternalServerError
    extends HttpServerErrorException {
        private static final long serialVersionUID = 1L;

        private InternalServerError(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.INTERNAL_SERVER_ERROR, statusText, headers, body, charset);
        }
    }

    public static final class NotImplemented
    extends HttpServerErrorException {
        private static final long serialVersionUID = 1L;

        private NotImplemented(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.NOT_IMPLEMENTED, statusText, headers, body, charset);
        }
    }

    public static final class BadGateway
    extends HttpServerErrorException {
        private BadGateway(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.BAD_GATEWAY, statusText, headers, body, charset);
        }
    }

    public static final class ServiceUnavailable
    extends HttpServerErrorException {
        private static final long serialVersionUID = 1L;

        private ServiceUnavailable(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.SERVICE_UNAVAILABLE, statusText, headers, body, charset);
        }
    }

    public static final class GatewayTimeout
    extends HttpServerErrorException {
        private static final long serialVersionUID = 1L;

        private GatewayTimeout(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.GATEWAY_TIMEOUT, statusText, headers, body, charset);
        }
    }
}

