/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.core.ResolvableType;
import infra.http.MediaType;
import infra.http.client.ClientHttpResponse;
import infra.http.converter.GenericHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.HttpMessageNotReadableException;
import infra.lang.Assert;
import infra.lang.Constant;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.FileCopyUtils;
import infra.web.client.IntrospectingClientHttpResponse;
import infra.web.client.ResponseExtractor;
import infra.web.client.RestClientException;
import infra.web.client.UnknownContentTypeException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.List;

public class HttpMessageConverterExtractor<T>
implements ResponseExtractor<T> {
    private final Logger logger;
    private final Type responseType;
    @Nullable
    private final Class<T> responseClass;
    private final List<HttpMessageConverter<?>> messageConverters;

    public HttpMessageConverterExtractor(Class<T> responseType, List<HttpMessageConverter<?>> messageConverters) {
        this((Type)responseType, messageConverters);
    }

    public HttpMessageConverterExtractor(Type responseType, List<HttpMessageConverter<?>> messageConverters) {
        this(responseType, messageConverters, LoggerFactory.getLogger(HttpMessageConverterExtractor.class));
    }

    public HttpMessageConverterExtractor(Type responseType, List<HttpMessageConverter<?>> messageConverters, Logger logger) {
        Assert.notNull((Object)responseType, (String)"'responseType' is required");
        Assert.notEmpty(messageConverters, (String)"'messageConverters' must not be empty");
        Assert.noNullElements(messageConverters, (String)"'messageConverters' must not contain null elements");
        this.logger = logger;
        this.responseType = responseType;
        this.messageConverters = messageConverters;
        this.responseClass = responseType instanceof Class ? (Class)responseType : null;
    }

    @Override
    public T extractData(ClientHttpResponse response) throws IOException {
        IntrospectingClientHttpResponse responseWrapper = new IntrospectingClientHttpResponse(response);
        if (!responseWrapper.hasMessageBody() || responseWrapper.hasEmptyMessageBody()) {
            return null;
        }
        MediaType contentType = this.getContentType(responseWrapper);
        try {
            for (HttpMessageConverter<T> httpMessageConverter : this.messageConverters) {
                if (httpMessageConverter instanceof GenericHttpMessageConverter) {
                    GenericHttpMessageConverter genericConverter = (GenericHttpMessageConverter)httpMessageConverter;
                    if (!genericConverter.canRead(this.responseType, null, contentType)) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Reading to [{}]", (Object)ResolvableType.forType((Type)this.responseType));
                    }
                    return genericConverter.read(this.responseType, null, responseWrapper);
                }
                if (this.responseClass == null || !httpMessageConverter.canRead(this.responseClass, contentType)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Reading to [{}] as \"{}\"", (Object)this.responseClass.getName(), (Object)contentType);
                }
                return (T)httpMessageConverter.read(this.responseClass, responseWrapper);
            }
        }
        catch (HttpMessageNotReadableException | IOException ex) {
            throw new RestClientException("Error while extracting response for type [%s] and content type [%s]".formatted(this.responseType, contentType), (Throwable)ex);
        }
        throw new UnknownContentTypeException(this.responseType, contentType, responseWrapper.getRawStatusCode(), responseWrapper.getStatusText(), responseWrapper.getHeaders(), HttpMessageConverterExtractor.getResponseBody(responseWrapper));
    }

    protected MediaType getContentType(ClientHttpResponse response) {
        MediaType contentType = response.getHeaders().getContentType();
        if (contentType == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("No content-type, using 'application/octet-stream'");
            }
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        return contentType;
    }

    private static byte[] getResponseBody(ClientHttpResponse response) {
        try {
            return FileCopyUtils.copyToByteArray((InputStream)response.getBody());
        }
        catch (IOException iOException) {
            return Constant.EMPTY_BYTES;
        }
    }
}

