/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.http.HttpHeaders;
import infra.http.HttpStatus;
import infra.http.HttpStatusCode;
import infra.lang.Nullable;
import infra.web.client.HttpStatusCodeException;
import java.nio.charset.Charset;

public class HttpClientErrorException
extends HttpStatusCodeException {
    public HttpClientErrorException(HttpStatusCode statusCode) {
        super(statusCode);
    }

    public HttpClientErrorException(HttpStatusCode statusCode, String statusText) {
        super(statusCode, statusText);
    }

    public HttpClientErrorException(HttpStatusCode statusCode, String statusText, @Nullable byte[] body, @Nullable Charset responseCharset) {
        super(statusCode, statusText, body, responseCharset);
    }

    public HttpClientErrorException(HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] body, @Nullable Charset responseCharset) {
        super(statusCode, statusText, headers, body, responseCharset);
    }

    public HttpClientErrorException(@Nullable String message, HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] body, @Nullable Charset responseCharset) {
        super(message, statusCode, statusText, headers, body, responseCharset);
    }

    public static HttpClientErrorException create(HttpStatusCode statusCode, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
        return HttpClientErrorException.create(null, statusCode, statusText, headers, body, charset);
    }

    public static HttpClientErrorException create(@Nullable String message, HttpStatusCode statusCode, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
        if (statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            return switch (status) {
                case HttpStatus.BAD_REQUEST -> new BadRequest(message, statusText, headers, body, charset);
                case HttpStatus.UNAUTHORIZED -> new Unauthorized(message, statusText, headers, body, charset);
                case HttpStatus.FORBIDDEN -> new Forbidden(message, statusText, headers, body, charset);
                case HttpStatus.NOT_FOUND -> new NotFound(message, statusText, headers, body, charset);
                case HttpStatus.METHOD_NOT_ALLOWED -> new MethodNotAllowed(message, statusText, headers, body, charset);
                case HttpStatus.NOT_ACCEPTABLE -> new NotAcceptable(message, statusText, headers, body, charset);
                case HttpStatus.CONFLICT -> new Conflict(message, statusText, headers, body, charset);
                case HttpStatus.GONE -> new Gone(message, statusText, headers, body, charset);
                case HttpStatus.UNSUPPORTED_MEDIA_TYPE -> new UnsupportedMediaType(message, statusText, headers, body, charset);
                case HttpStatus.TOO_MANY_REQUESTS -> new TooManyRequests(message, statusText, headers, body, charset);
                case HttpStatus.UNPROCESSABLE_ENTITY -> new UnprocessableEntity(message, statusText, headers, body, charset);
                default -> new HttpClientErrorException(message, statusCode, statusText, headers, body, charset);
            };
        }
        if (message != null) {
            return new HttpClientErrorException(message, statusCode, statusText, headers, body, charset);
        }
        return new HttpClientErrorException(statusCode, statusText, headers, body, charset);
    }

    public static final class BadRequest
    extends HttpClientErrorException {
        private BadRequest(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.BAD_REQUEST, statusText, headers, body, charset);
        }
    }

    public static final class Unauthorized
    extends HttpClientErrorException {
        private Unauthorized(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.UNAUTHORIZED, statusText, headers, body, charset);
        }
    }

    public static final class Forbidden
    extends HttpClientErrorException {
        private Forbidden(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.FORBIDDEN, statusText, headers, body, charset);
        }
    }

    public static final class NotFound
    extends HttpClientErrorException {
        private NotFound(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.NOT_FOUND, statusText, headers, body, charset);
        }
    }

    public static final class MethodNotAllowed
    extends HttpClientErrorException {
        private MethodNotAllowed(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.METHOD_NOT_ALLOWED, statusText, headers, body, charset);
        }
    }

    public static final class NotAcceptable
    extends HttpClientErrorException {
        private NotAcceptable(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.NOT_ACCEPTABLE, statusText, headers, body, charset);
        }
    }

    public static final class Conflict
    extends HttpClientErrorException {
        private Conflict(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.CONFLICT, statusText, headers, body, charset);
        }
    }

    public static final class Gone
    extends HttpClientErrorException {
        private Gone(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.GONE, statusText, headers, body, charset);
        }
    }

    public static final class UnsupportedMediaType
    extends HttpClientErrorException {
        private UnsupportedMediaType(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.UNSUPPORTED_MEDIA_TYPE, statusText, headers, body, charset);
        }
    }

    public static final class TooManyRequests
    extends HttpClientErrorException {
        private TooManyRequests(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.TOO_MANY_REQUESTS, statusText, headers, body, charset);
        }
    }

    public static final class UnprocessableEntity
    extends HttpClientErrorException {
        private UnprocessableEntity(@Nullable String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.UNPROCESSABLE_ENTITY, statusText, headers, body, charset);
        }
    }
}

