/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.http.HttpHeaders;
import infra.http.HttpStatusCode;
import infra.http.client.ClientHttpRequestFactory;
import infra.http.client.ClientHttpRequestInitializer;
import infra.http.client.ClientHttpRequestInterceptor;
import infra.http.client.HttpComponentsClientHttpRequestFactory;
import infra.http.client.InterceptingClientHttpRequestFactory;
import infra.http.client.JdkClientHttpRequestFactory;
import infra.http.client.ReactorClientHttpRequestFactory;
import infra.http.converter.AllEncompassingFormHttpMessageConverter;
import infra.http.converter.ByteArrayHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.ResourceHttpMessageConverter;
import infra.http.converter.StringHttpMessageConverter;
import infra.http.converter.cbor.MappingJackson2CborHttpMessageConverter;
import infra.http.converter.json.GsonHttpMessageConverter;
import infra.http.converter.json.JsonbHttpMessageConverter;
import infra.http.converter.json.MappingJackson2HttpMessageConverter;
import infra.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import infra.http.converter.yaml.MappingJackson2YamlHttpMessageConverter;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.ClassUtils;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.web.client.DefaultRestClient;
import infra.web.client.ResponseErrorHandler;
import infra.web.client.RestClient;
import infra.web.client.RestTemplate;
import infra.web.client.StatusHandler;
import infra.web.util.DefaultUriBuilderFactory;
import infra.web.util.UriBuilderFactory;
import infra.web.util.UriComponentsBuilder;
import infra.web.util.UriTemplateHandler;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class DefaultRestClientBuilder
implements RestClient.Builder {
    private static final boolean httpComponentsClientPresent;
    private static final boolean reactorNettyClientPresent;
    private static final boolean jackson2Present;
    private static final boolean gsonPresent;
    private static final boolean jsonbPresent;
    private static final boolean jackson2SmilePresent;
    private static final boolean jackson2CborPresent;
    private static final boolean jackson2YamlPresent;
    @Nullable
    private URI baseURI;
    @Nullable
    private Map<String, ?> defaultUriVariables;
    @Nullable
    private UriBuilderFactory uriBuilderFactory;
    @Nullable
    private HttpHeaders defaultHeaders;
    @Nullable
    private MultiValueMap<String, String> defaultCookies;
    @Nullable
    private Consumer<RestClient.RequestHeadersSpec<?>> defaultRequest;
    @Nullable
    private List<ResponseErrorHandler> statusHandlers;
    @Nullable
    private ClientHttpRequestFactory requestFactory;
    @Nullable
    private List<HttpMessageConverter<?>> messageConverters;
    @Nullable
    private List<ClientHttpRequestInterceptor> interceptors;
    @Nullable
    private List<ClientHttpRequestInitializer> initializers;
    private boolean ignoreStatus = false;

    public DefaultRestClientBuilder() {
    }

    public DefaultRestClientBuilder(DefaultRestClientBuilder other) {
        Assert.notNull((Object)other, (String)"Other is required");
        this.baseURI = other.baseURI;
        this.ignoreStatus = other.ignoreStatus;
        this.defaultRequest = other.defaultRequest;
        this.requestFactory = other.requestFactory;
        this.uriBuilderFactory = other.uriBuilderFactory;
        this.interceptors = other.interceptors != null ? new ArrayList<ClientHttpRequestInterceptor>(other.interceptors) : null;
        this.initializers = other.initializers != null ? new ArrayList<ClientHttpRequestInitializer>(other.initializers) : null;
        this.defaultHeaders = other.defaultHeaders != null ? HttpHeaders.copyOf((Map<String, List<String>>)((Object)other.defaultHeaders)) : null;
        this.defaultCookies = other.defaultCookies != null ? MultiValueMap.copyOf(other.defaultCookies) : null;
        this.statusHandlers = other.statusHandlers != null ? new ArrayList<ResponseErrorHandler>(other.statusHandlers) : null;
        this.messageConverters = other.messageConverters != null ? new ArrayList(other.messageConverters) : null;
        this.defaultUriVariables = other.defaultUriVariables != null ? new LinkedHashMap(other.defaultUriVariables) : null;
    }

    public DefaultRestClientBuilder(RestTemplate restTemplate) {
        Assert.notNull((Object)restTemplate, (String)"RestTemplate is required");
        this.uriBuilderFactory = DefaultRestClientBuilder.getUriBuilderFactory(restTemplate);
        this.statusHandlers = new ArrayList<ResponseErrorHandler>();
        this.statusHandlers.add(restTemplate.getErrorHandler());
        this.requestFactory = DefaultRestClientBuilder.getRequestFactory(restTemplate);
        this.messageConverters = new ArrayList(restTemplate.getMessageConverters());
        if (CollectionUtils.isNotEmpty(restTemplate.getInterceptors())) {
            this.interceptors = new ArrayList<ClientHttpRequestInterceptor>(restTemplate.getInterceptors());
        }
        if (CollectionUtils.isNotEmpty(restTemplate.getHttpRequestInitializers())) {
            this.initializers = new ArrayList<ClientHttpRequestInitializer>(restTemplate.getHttpRequestInitializers());
        }
    }

    @Nullable
    private static UriBuilderFactory getUriBuilderFactory(RestTemplate restTemplate) {
        UriTemplateHandler uriTemplateHandler = restTemplate.getUriTemplateHandler();
        if (uriTemplateHandler instanceof DefaultUriBuilderFactory) {
            DefaultUriBuilderFactory builderFactory = (DefaultUriBuilderFactory)uriTemplateHandler;
            if (DefaultRestClientBuilder.hasRestTemplateDefaults(builderFactory)) {
                return null;
            }
            return builderFactory;
        }
        if (uriTemplateHandler instanceof UriBuilderFactory) {
            UriBuilderFactory builderFactory = (UriBuilderFactory)uriTemplateHandler;
            return builderFactory;
        }
        return null;
    }

    private static boolean hasRestTemplateDefaults(DefaultUriBuilderFactory factory) {
        return !factory.hasBaseUri() && factory.getEncodingMode() == DefaultUriBuilderFactory.EncodingMode.URI_COMPONENT && CollectionUtils.isEmpty(factory.getDefaultUriVariables()) && factory.shouldParsePath();
    }

    private static ClientHttpRequestFactory getRequestFactory(RestTemplate restTemplate) {
        ClientHttpRequestFactory requestFactory = restTemplate.getRequestFactory();
        if (requestFactory instanceof InterceptingClientHttpRequestFactory) {
            InterceptingClientHttpRequestFactory factory = (InterceptingClientHttpRequestFactory)requestFactory;
            return factory.getRequestFactory();
        }
        return requestFactory;
    }

    @Override
    public RestClient.Builder baseURI(@Nullable String baseURI) {
        if (baseURI != null) {
            this.baseURI = URI.create(baseURI);
        }
        return this;
    }

    @Override
    public RestClient.Builder baseURI(@Nullable URI baseURI) {
        this.baseURI = baseURI;
        return this;
    }

    @Override
    public RestClient.Builder defaultUriVariables(@Nullable Map<String, ?> defaultUriVariables) {
        this.defaultUriVariables = defaultUriVariables;
        return this;
    }

    @Override
    public RestClient.Builder uriBuilderFactory(@Nullable UriBuilderFactory uriBuilderFactory) {
        this.uriBuilderFactory = uriBuilderFactory;
        return this;
    }

    @Override
    public RestClient.Builder defaultHeader(String header, String ... values) {
        this.initHeaders().setOrRemove(header, values);
        return this;
    }

    @Override
    public RestClient.Builder defaultHeaders(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.initHeaders());
        return this;
    }

    @Override
    public RestClient.Builder defaultHeaders(HttpHeaders headers) {
        this.initHeaders().setAll((Map)((Object)headers));
        return this;
    }

    private HttpHeaders initHeaders() {
        if (this.defaultHeaders == null) {
            this.defaultHeaders = HttpHeaders.forWritable();
        }
        return this.defaultHeaders;
    }

    @Override
    public RestClient.Builder defaultCookie(String cookie, String ... values) {
        this.initCookies().setOrRemove((Object)cookie, (Object[])values);
        return this;
    }

    @Override
    public RestClient.Builder defaultCookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
        cookiesConsumer.accept(this.initCookies());
        return this;
    }

    @Override
    public RestClient.Builder defaultCookies(MultiValueMap<String, String> cookies) {
        this.initCookies().setAll(cookies);
        return this;
    }

    private MultiValueMap<String, String> initCookies() {
        if (this.defaultCookies == null) {
            this.defaultCookies = new LinkedMultiValueMap(3);
        }
        return this.defaultCookies;
    }

    @Override
    public RestClient.Builder defaultRequest(Consumer<RestClient.RequestHeadersSpec<?>> defaultRequest) {
        this.defaultRequest = this.defaultRequest != null ? this.defaultRequest.andThen(defaultRequest) : defaultRequest;
        return this;
    }

    @Override
    public RestClient.Builder defaultStatusHandler(Predicate<HttpStatusCode> statusPredicate, RestClient.ErrorHandler errorHandler) {
        return this.defaultStatusHandlerInternal(StatusHandler.of(statusPredicate, errorHandler));
    }

    @Override
    public RestClient.Builder defaultStatusHandler(ResponseErrorHandler errorHandler) {
        return this.defaultStatusHandlerInternal(errorHandler);
    }

    @Override
    public RestClient.Builder ignoreStatus(boolean ignoreStatus) {
        this.ignoreStatus = ignoreStatus;
        return this;
    }

    private RestClient.Builder defaultStatusHandlerInternal(ResponseErrorHandler statusHandler) {
        if (this.statusHandlers == null) {
            this.statusHandlers = new ArrayList<ResponseErrorHandler>();
        }
        this.statusHandlers.add(statusHandler);
        return this;
    }

    @Override
    public RestClient.Builder requestInterceptor(ClientHttpRequestInterceptor interceptor) {
        Assert.notNull((Object)interceptor, (String)"Interceptor is required");
        this.initInterceptors().add(interceptor);
        return this;
    }

    @Override
    public RestClient.Builder requestInterceptors(Consumer<List<ClientHttpRequestInterceptor>> interceptorsConsumer) {
        interceptorsConsumer.accept(this.initInterceptors());
        return this;
    }

    private List<ClientHttpRequestInterceptor> initInterceptors() {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<ClientHttpRequestInterceptor>();
        }
        return this.interceptors;
    }

    @Override
    public RestClient.Builder requestInitializer(ClientHttpRequestInitializer initializer) {
        Assert.notNull((Object)initializer, (String)"Initializer is required");
        this.initInitializers().add(initializer);
        return this;
    }

    @Override
    public RestClient.Builder requestInitializers(Consumer<List<ClientHttpRequestInitializer>> initializersConsumer) {
        initializersConsumer.accept(this.initInitializers());
        return this;
    }

    private List<ClientHttpRequestInitializer> initInitializers() {
        if (this.initializers == null) {
            this.initializers = new ArrayList<ClientHttpRequestInitializer>();
        }
        return this.initializers;
    }

    @Override
    public RestClient.Builder requestFactory(ClientHttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
        return this;
    }

    @Override
    public RestClient.Builder messageConverters(Consumer<List<HttpMessageConverter<?>>> configurer) {
        configurer.accept(this.initMessageConverters());
        this.validateConverters(this.messageConverters);
        return this;
    }

    @Override
    public RestClient.Builder messageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.validateConverters(messageConverters);
        this.messageConverters = Collections.unmodifiableList(messageConverters);
        return this;
    }

    @Override
    public RestClient.Builder apply(Consumer<RestClient.Builder> builderConsumer) {
        builderConsumer.accept(this);
        return this;
    }

    private List<HttpMessageConverter<?>> initMessageConverters() {
        if (this.messageConverters == null) {
            this.messageConverters = new ArrayList();
            this.messageConverters.add(new ByteArrayHttpMessageConverter());
            this.messageConverters.add(new StringHttpMessageConverter());
            this.messageConverters.add(new ResourceHttpMessageConverter(false));
            this.messageConverters.add(new AllEncompassingFormHttpMessageConverter());
            if (jackson2Present) {
                this.messageConverters.add(new MappingJackson2HttpMessageConverter());
            } else if (gsonPresent) {
                this.messageConverters.add(new GsonHttpMessageConverter());
            } else if (jsonbPresent) {
                this.messageConverters.add(new JsonbHttpMessageConverter());
            }
            if (jackson2SmilePresent) {
                this.messageConverters.add(new MappingJackson2SmileHttpMessageConverter());
            }
            if (jackson2CborPresent) {
                this.messageConverters.add(new MappingJackson2CborHttpMessageConverter());
            }
            if (jackson2YamlPresent) {
                this.messageConverters.add(new MappingJackson2YamlHttpMessageConverter());
            }
        }
        return this.messageConverters;
    }

    @Override
    public RestClient.Builder clone() {
        return new DefaultRestClientBuilder(this);
    }

    private void validateConverters(@Nullable List<HttpMessageConverter<?>> messageConverters) {
        Assert.notEmpty(messageConverters, (String)"At least one HttpMessageConverter is required");
        Assert.noNullElements(messageConverters, (String)"The HttpMessageConverter list must not contain null elements");
    }

    @Override
    public RestClient build() {
        ClientHttpRequestFactory requestFactory = this.initRequestFactory();
        UriBuilderFactory uriBuilderFactory = this.initUriBuilderFactory();
        HttpHeaders defaultHeaders = this.defaultHeaders != null ? HttpHeaders.copyOf((Map<String, List<String>>)((Object)this.defaultHeaders)).asReadOnly() : null;
        MultiValueMap defaultCookies = this.defaultCookies != null ? MultiValueMap.copyOf(this.defaultCookies).asReadOnly() : null;
        List<HttpMessageConverter<?>> messageConverters = this.messageConverters != null ? this.messageConverters : this.initMessageConverters();
        return new DefaultRestClient(requestFactory, this.interceptors, this.initializers, uriBuilderFactory, defaultHeaders, (MultiValueMap<String, String>)defaultCookies, this.defaultRequest, this.statusHandlers, messageConverters, new DefaultRestClientBuilder(this), this.ignoreStatus);
    }

    private ClientHttpRequestFactory initRequestFactory() {
        if (this.requestFactory != null) {
            return this.requestFactory;
        }
        if (httpComponentsClientPresent) {
            return new HttpComponentsClientHttpRequestFactory();
        }
        if (reactorNettyClientPresent) {
            return new ReactorClientHttpRequestFactory();
        }
        return new JdkClientHttpRequestFactory();
    }

    private UriBuilderFactory initUriBuilderFactory() {
        if (this.uriBuilderFactory != null) {
            return this.uriBuilderFactory;
        }
        DefaultUriBuilderFactory factory = this.baseURI != null ? new DefaultUriBuilderFactory(UriComponentsBuilder.fromUri(this.baseURI)) : new DefaultUriBuilderFactory();
        factory.setDefaultUriVariables(this.defaultUriVariables);
        return factory;
    }

    static {
        ClassLoader loader = DefaultRestClientBuilder.class.getClassLoader();
        reactorNettyClientPresent = ClassUtils.isPresent((String)"reactor.netty.http.client.HttpClient", (ClassLoader)loader);
        httpComponentsClientPresent = ClassUtils.isPresent((String)"org.apache.hc.client5.http.classic.HttpClient", (ClassLoader)loader);
        jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)loader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)loader);
        gsonPresent = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)loader);
        jsonbPresent = ClassUtils.isPresent((String)"jakarta.json.bind.Jsonb", (ClassLoader)loader);
        jackson2SmilePresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.smile.SmileFactory", (ClassLoader)loader);
        jackson2CborPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.cbor.CBORFactory", (ClassLoader)loader);
        jackson2YamlPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.yaml.YAMLFactory", (ClassLoader)loader);
    }
}

