/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.core.Pair;
import infra.core.ParameterizedTypeReference;
import infra.core.ResolvableType;
import infra.http.HttpHeaders;
import infra.http.HttpMethod;
import infra.http.HttpRequest;
import infra.http.HttpStatusCode;
import infra.http.MediaType;
import infra.http.ResponseEntity;
import infra.http.StreamingHttpOutputMessage;
import infra.http.client.ClientHttpRequest;
import infra.http.client.ClientHttpRequestFactory;
import infra.http.client.ClientHttpRequestInitializer;
import infra.http.client.ClientHttpRequestInterceptor;
import infra.http.client.ClientHttpResponse;
import infra.http.client.InterceptingClientHttpRequestFactory;
import infra.http.converter.GenericHttpMessageConverter;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.HttpMessageNotReadableException;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.logging.Logger;
import infra.logging.LoggerFactory;
import infra.util.CollectionUtils;
import infra.util.LinkedMultiValueMap;
import infra.util.MultiValueMap;
import infra.util.concurrent.Future;
import infra.web.client.ClientResponse;
import infra.web.client.DefaultRestClientBuilder;
import infra.web.client.IntrospectingClientHttpResponse;
import infra.web.client.ResourceAccessException;
import infra.web.client.ResponseErrorHandler;
import infra.web.client.RestClient;
import infra.web.client.RestClientException;
import infra.web.client.RestClientUtils;
import infra.web.client.StatusHandler;
import infra.web.client.UnknownContentTypeException;
import infra.web.util.UriBuilder;
import infra.web.util.UriBuilderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

final class DefaultRestClient
implements RestClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRestClient.class);
    private final ClientHttpRequestFactory clientRequestFactory;
    @Nullable
    private volatile ClientHttpRequestFactory interceptingRequestFactory;
    @Nullable
    private final List<ClientHttpRequestInitializer> initializers;
    @Nullable
    private final List<ClientHttpRequestInterceptor> interceptors;
    private final UriBuilderFactory uriBuilderFactory;
    @Nullable
    private final HttpHeaders defaultHeaders;
    @Nullable
    private final MultiValueMap<String, String> defaultCookies;
    @Nullable
    private final List<ResponseErrorHandler> defaultStatusHandlers;
    private final ResponseErrorHandler defaultStatusHandler;
    private final DefaultRestClientBuilder builder;
    private final List<HttpMessageConverter<?>> messageConverters;
    @Nullable
    private final Consumer<RestClient.RequestHeadersSpec<?>> defaultRequest;
    private final boolean ignoreStatusHandlers;

    DefaultRestClient(ClientHttpRequestFactory clientRequestFactory, @Nullable List<ClientHttpRequestInterceptor> interceptors, @Nullable List<ClientHttpRequestInitializer> initializers, UriBuilderFactory uriBuilderFactory, @Nullable HttpHeaders defaultHeaders, @Nullable MultiValueMap<String, String> defaultCookies, @Nullable Consumer<RestClient.RequestHeadersSpec<?>> defaultRequest, @Nullable List<ResponseErrorHandler> statusHandlers, List<HttpMessageConverter<?>> messageConverters, DefaultRestClientBuilder builder, boolean ignoreStatusHandlers) {
        this.clientRequestFactory = clientRequestFactory;
        this.initializers = initializers;
        this.interceptors = interceptors;
        this.uriBuilderFactory = uriBuilderFactory;
        this.defaultHeaders = defaultHeaders;
        this.defaultCookies = defaultCookies;
        this.defaultRequest = defaultRequest;
        this.defaultStatusHandlers = statusHandlers;
        this.messageConverters = messageConverters;
        this.builder = builder;
        this.defaultStatusHandler = StatusHandler.defaultHandler(messageConverters);
        this.ignoreStatusHandlers = ignoreStatusHandlers;
    }

    @Override
    public RestClient.RequestHeadersUriSpec<?> get() {
        return this.methodInternal(HttpMethod.GET);
    }

    @Override
    public RestClient.RequestHeadersUriSpec<?> head() {
        return this.methodInternal(HttpMethod.HEAD);
    }

    @Override
    public RestClient.RequestBodyUriSpec post() {
        return this.methodInternal(HttpMethod.POST);
    }

    @Override
    public RestClient.RequestBodyUriSpec put() {
        return this.methodInternal(HttpMethod.PUT);
    }

    @Override
    public RestClient.RequestBodyUriSpec patch() {
        return this.methodInternal(HttpMethod.PATCH);
    }

    @Override
    public RestClient.RequestBodyUriSpec delete() {
        return this.methodInternal(HttpMethod.DELETE);
    }

    @Override
    public RestClient.RequestHeadersUriSpec<?> options() {
        return this.methodInternal(HttpMethod.OPTIONS);
    }

    @Override
    public RestClient.RequestBodyUriSpec method(HttpMethod method) {
        Assert.notNull((Object)((Object)method), (String)"HttpMethod is required");
        return this.methodInternal(method);
    }

    private RestClient.RequestBodyUriSpec methodInternal(HttpMethod httpMethod) {
        DefaultRequestBodyUriSpec spec = new DefaultRequestBodyUriSpec(httpMethod);
        if (this.defaultRequest != null) {
            this.defaultRequest.accept(spec);
        }
        return spec;
    }

    @Override
    public RestClient.Builder mutate() {
        return new DefaultRestClientBuilder(this.builder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <T> T readWithMessageConverters(ClientHttpResponse clientResponse, @Nullable ResponseConsumer callback, Type bodyType, Class<T> bodyClass) {
        MediaType contentType = DefaultRestClient.getContentType(clientResponse);
        try (IntrospectingClientHttpResponse responseWrapper = new IntrospectingClientHttpResponse(clientResponse);){
            HttpMessageConverter<T> httpMessageConverter;
            block17: {
                if (callback != null) {
                    callback.accept(clientResponse);
                }
                if (!responseWrapper.hasMessageBody() || responseWrapper.hasEmptyMessageBody()) {
                    T t = null;
                    return t;
                }
                Iterator<HttpMessageConverter<?>> iterator = this.messageConverters.iterator();
                while (iterator.hasNext()) {
                    httpMessageConverter = iterator.next();
                    if (httpMessageConverter instanceof GenericHttpMessageConverter) {
                        GenericHttpMessageConverter ghmc = (GenericHttpMessageConverter)httpMessageConverter;
                        if (!ghmc.canRead(bodyType, null, contentType)) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Reading to [{}]", (Object)ResolvableType.forType((Type)bodyType));
                        }
                        Object t = ghmc.read(bodyType, null, responseWrapper);
                        return t;
                    }
                    if (!httpMessageConverter.canRead(bodyClass, contentType)) {
                        continue;
                    }
                    break block17;
                }
                throw new UnknownContentTypeException(bodyType, contentType, responseWrapper.getStatusCode(), responseWrapper.getStatusText(), responseWrapper.getHeaders(), RestClientUtils.getBody(responseWrapper));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Reading to [{}] as \"{}\"", (Object)bodyClass.getName(), (Object)contentType);
            }
            Object obj = httpMessageConverter.read(bodyClass, responseWrapper);
            return (T)obj;
        }
        catch (HttpMessageNotReadableException | IOException ex) {
            throw new RestClientException("Error while extracting response for type [%s] and content type [%s]".formatted(ResolvableType.forType((Type)bodyType), contentType), (Throwable)ex);
        }
    }

    private static MediaType getContentType(ClientHttpResponse clientResponse) {
        MediaType contentType = clientResponse.getHeaders().getContentType();
        if (contentType == null) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        return contentType;
    }

    private static <T> Class<T> bodyClass(Type type) {
        ParameterizedType parameterizedType;
        Type type2;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        if (type instanceof ParameterizedType && (type2 = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class rawType = (Class)type2;
            return rawType;
        }
        return Object.class;
    }

    private void applyStatusHandlers(HttpRequest request, ClientHttpResponse response, @Nullable List<ResponseErrorHandler> statusHandlers) throws IOException {
        if (response instanceof DefaultClientResponse) {
            DefaultClientResponse cr = (DefaultClientResponse)response;
            response = cr.delegate;
        }
        if (this.defaultStatusHandlers != null) {
            for (ResponseErrorHandler handler : this.defaultStatusHandlers) {
                if (!handler.hasError(response)) continue;
                handler.handleError(request, response);
                return;
            }
        }
        if (statusHandlers != null) {
            for (ResponseErrorHandler handler : statusHandlers) {
                if (!handler.hasError(response)) continue;
                handler.handleError(request, response);
                return;
            }
        }
        if (this.defaultStatusHandler.hasError(response)) {
            this.defaultStatusHandler.handleError(request, response);
        }
    }

    private class DefaultRequestBodyUriSpec
    implements RestClient.RequestBodyUriSpec {
        private final HttpMethod httpMethod;
        @Nullable
        private URI uri;
        @Nullable
        private HttpHeaders headers;
        @Nullable
        private MultiValueMap<String, String> cookies;
        @Nullable
        private InternalBody body;
        @Nullable
        private Consumer<ClientHttpRequest> httpRequestConsumer;
        @Nullable
        private Map<String, Object> attributes;

        public DefaultRequestBodyUriSpec(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public RestClient.RequestBodySpec uri(String uriTemplate, Object ... uriVariables) {
            return this.uri(DefaultRestClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public RestClient.RequestBodySpec uri(String uriTemplate, Map<String, ?> uriVariables) {
            return this.uri(DefaultRestClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public RestClient.RequestBodySpec uri(String uriTemplate, Function<UriBuilder, URI> uriFunction) {
            return this.uri(uriFunction.apply(DefaultRestClient.this.uriBuilderFactory.uriString(uriTemplate)));
        }

        @Override
        public RestClient.RequestBodySpec uri(Function<UriBuilder, URI> uriFunction) {
            return this.uri(uriFunction.apply(DefaultRestClient.this.uriBuilderFactory.builder()));
        }

        @Override
        public RestClient.RequestBodySpec uri(URI uri) {
            if (uri.isAbsolute()) {
                this.uri = uri;
            } else {
                URI baseUri = DefaultRestClient.this.uriBuilderFactory.expand("", new Object[0]);
                this.uri = baseUri.resolve(uri);
            }
            return this;
        }

        private HttpHeaders httpHeaders() {
            if (this.headers == null) {
                this.headers = HttpHeaders.forWritable();
            }
            return this.headers;
        }

        private MultiValueMap<String, String> cookies() {
            if (this.cookies == null) {
                this.cookies = new LinkedMultiValueMap(3);
            }
            return this.cookies;
        }

        @Override
        public DefaultRequestBodyUriSpec header(String headerName, String ... headerValues) {
            this.httpHeaders().setOrRemove(headerName, headerValues);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec headers(Consumer<HttpHeaders> headersConsumer) {
            headersConsumer.accept(this.httpHeaders());
            return this;
        }

        @Override
        public RestClient.RequestBodySpec headers(@Nullable HttpHeaders headers) {
            this.httpHeaders().setAll((Map)((Object)headers));
            return this;
        }

        @Override
        public RestClient.RequestBodySpec cookie(String name, String value) {
            this.cookies().add((Object)name, (Object)value);
            return this;
        }

        @Override
        public RestClient.RequestBodySpec cookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
            cookiesConsumer.accept(this.cookies());
            return this;
        }

        @Override
        public RestClient.RequestBodySpec cookies(MultiValueMap<String, String> cookies) {
            this.cookies().setAll(cookies);
            return this;
        }

        @Override
        public RestClient.RequestBodySpec attribute(String name, Object value) {
            this.attributes().put(name, value);
            return this;
        }

        @Override
        public RestClient.RequestBodySpec attributes(Consumer<Map<String, Object>> attributesConsumer) {
            attributesConsumer.accept(this.attributes());
            return this;
        }

        @Override
        public RestClient.RequestBodySpec attributes(@Nullable Map<String, Object> attributes) {
            if (CollectionUtils.isNotEmpty(attributes)) {
                this.attributes().putAll(attributes);
            }
            return this;
        }

        private Map<String, Object> attributes() {
            Map<String, Object> attributes = this.attributes;
            if (attributes == null) {
                this.attributes = attributes = new LinkedHashMap<String, Object>(4);
            }
            return attributes;
        }

        @Override
        public DefaultRequestBodyUriSpec accept(MediaType ... acceptableMediaTypes) {
            this.httpHeaders().setAccept(Arrays.asList(acceptableMediaTypes));
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec acceptCharset(Charset ... acceptableCharsets) {
            this.httpHeaders().setAcceptCharset(Arrays.asList(acceptableCharsets));
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec contentType(MediaType contentType) {
            this.httpHeaders().setContentType(contentType);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec contentLength(long contentLength) {
            this.httpHeaders().setContentLength(contentLength);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec ifModifiedSince(ZonedDateTime ifModifiedSince) {
            this.httpHeaders().setIfModifiedSince(ifModifiedSince);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec ifNoneMatch(String ... ifNoneMatches) {
            this.httpHeaders().setIfNoneMatch(Arrays.asList(ifNoneMatches));
            return this;
        }

        @Override
        public RestClient.RequestBodySpec httpRequest(Consumer<ClientHttpRequest> requestConsumer) {
            this.httpRequestConsumer = this.httpRequestConsumer != null ? this.httpRequestConsumer.andThen(requestConsumer) : requestConsumer;
            return this;
        }

        @Override
        public RestClient.RequestBodySpec body(Object body) {
            this.body = request -> this.writeWithMessageConverters(body, body.getClass(), request);
            return this;
        }

        @Override
        public <T> RestClient.RequestBodySpec body(T body, ParameterizedTypeReference<T> bodyType) {
            this.body = request -> this.writeWithMessageConverters(body, bodyType.getType(), request);
            return this;
        }

        @Override
        public RestClient.RequestBodySpec body(StreamingHttpOutputMessage.Body body) {
            this.body = request -> body.writeTo(request.getBody());
            return this;
        }

        private void writeWithMessageConverters(Object body, Type bodyType, ClientHttpRequest clientRequest) throws IOException {
            MediaType contentType = clientRequest.getHeaders().getContentType();
            Class<?> bodyClass = body.getClass();
            for (HttpMessageConverter<?> hmc : DefaultRestClient.this.messageConverters) {
                if (hmc instanceof GenericHttpMessageConverter) {
                    GenericHttpMessageConverter ghmc = (GenericHttpMessageConverter)hmc;
                    if (!ghmc.canWrite(bodyType, bodyClass, contentType)) continue;
                    this.logBody(body, contentType, ghmc);
                    ghmc.write(body, bodyType, contentType, clientRequest);
                    return;
                }
                if (!hmc.canWrite(bodyClass, contentType)) continue;
                this.logBody(body, contentType, hmc);
                hmc.write(body, contentType, clientRequest);
                return;
            }
            String message = "No HttpMessageConverter for " + bodyClass.getName();
            if (contentType != null) {
                message = message + " and content type \"%s\"".formatted(contentType);
            }
            throw new RestClientException(message);
        }

        private void logBody(Object body, @Nullable MediaType mediaType, HttpMessageConverter<?> converter) {
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder("Writing [");
                msg.append(body);
                msg.append("] ");
                if (mediaType != null) {
                    msg.append("as \"");
                    msg.append(mediaType);
                    msg.append("\" ");
                }
                msg.append("with ");
                msg.append(converter.getClass().getName());
                logger.debug(msg.toString());
            }
        }

        @Override
        public RestClient.ResponseSpec retrieve() {
            return this.exchangeInternal((x$0, x$1) -> new DefaultResponseSpec(x$0, x$1), false);
        }

        @Override
        public RestClient.AsyncSpec async(@Nullable Executor executor) {
            Pair<ClientHttpRequest, Future<ClientHttpResponse>> pair = this.asyncInternal(executor);
            return new DefaultAsyncSpec((HttpRequest)pair.first, (Future<ClientHttpResponse>)((Future)pair.second));
        }

        @Override
        public Future<ClientResponse> send(@Nullable Executor executor) {
            return ((Future)this.asyncInternal((Executor)executor).second).map(x$0 -> new DefaultClientResponse((ClientHttpResponse)x$0));
        }

        private Pair<ClientHttpRequest, Future<ClientHttpResponse>> asyncInternal(@Nullable Executor executor) {
            ClientHttpRequest clientRequest = null;
            try {
                URI uri = this.initUri();
                clientRequest = this.createRequest(uri);
                return Pair.of((Object)clientRequest, (Object)clientRequest.async(executor).onErrorMap(IOException.class, ex -> DefaultRequestBodyUriSpec.createResourceAccessException(uri, this.httpMethod, ex)));
            }
            catch (Throwable e) {
                return Pair.of((Object)clientRequest, (Object)Future.failed((Throwable)e, (Executor)executor));
            }
        }

        @Override
        public ClientResponse execute() {
            return this.execute(true);
        }

        @Override
        public ClientResponse execute(boolean close) {
            return this.exchangeInternal((clientRequest, clientResponse) -> clientResponse, close);
        }

        @Override
        public <T> T exchange(RestClient.RequestHeadersSpec.ExchangeFunction<T> exchangeFunction, boolean close) {
            return this.exchangeInternal(exchangeFunction, close);
        }

        private <T> T exchangeInternal(RestClient.RequestHeadersSpec.ExchangeFunction<T> exchangeFunction, boolean close) {
            Assert.notNull(exchangeFunction, (String)"ExchangeFunction is required");
            URI uri = this.initUri();
            ClientHttpRequest clientRequest = this.createRequest(uri);
            ClientHttpResponse clientResponse = null;
            try {
                clientResponse = clientRequest.execute();
                DefaultClientResponse convertibleWrapper = new DefaultClientResponse(clientResponse);
                T t = exchangeFunction.exchange(clientRequest, convertibleWrapper);
                return t;
            }
            catch (IOException ex) {
                throw DefaultRequestBodyUriSpec.createResourceAccessException(uri, this.httpMethod, ex);
            }
            finally {
                if (close && clientResponse != null) {
                    clientResponse.close();
                }
            }
        }

        private URI initUri() {
            return this.uri != null ? this.uri : DefaultRestClient.this.uriBuilderFactory.expand("", new Object[0]);
        }

        private ClientHttpRequest createRequest(URI uri) throws ResourceAccessException {
            ClientHttpRequestFactory factory;
            if (DefaultRestClient.this.interceptors != null) {
                factory = DefaultRestClient.this.interceptingRequestFactory;
                if (factory == null) {
                    DefaultRestClient.this.interceptingRequestFactory = factory = new InterceptingClientHttpRequestFactory(DefaultRestClient.this.clientRequestFactory, DefaultRestClient.this.interceptors);
                }
            } else {
                factory = DefaultRestClient.this.clientRequestFactory;
            }
            try {
                ClientHttpRequest request = factory.createRequest(uri, this.httpMethod);
                HttpHeaders headers = request.getHeaders();
                headers.setAll((Map)((Object)DefaultRestClient.this.defaultHeaders));
                headers.setAll((Map)((Object)this.headers));
                String serializedCookies = this.serializeCookies();
                if (serializedCookies != null) {
                    headers.add("Cookie", serializedCookies);
                }
                request.setAttributes(this.attributes);
                if (DefaultRestClient.this.initializers != null) {
                    for (ClientHttpRequestInitializer initializer : DefaultRestClient.this.initializers) {
                        initializer.initialize(request);
                    }
                }
                if (this.body != null) {
                    this.body.writeTo(request);
                }
                if (this.httpRequestConsumer != null) {
                    this.httpRequestConsumer.accept(request);
                }
                return request;
            }
            catch (IOException ex) {
                throw DefaultRequestBodyUriSpec.createResourceAccessException(uri, this.httpMethod, ex);
            }
        }

        @Nullable
        private String serializeCookies() {
            LinkedMultiValueMap map;
            LinkedMultiValueMap defaultCookies = DefaultRestClient.this.defaultCookies;
            if (CollectionUtils.isEmpty(this.cookies)) {
                map = defaultCookies;
            } else if (CollectionUtils.isEmpty(defaultCookies)) {
                map = this.cookies;
            } else {
                map = new LinkedMultiValueMap(defaultCookies.size() + this.cookies.size());
                map.putAll((Map)defaultCookies);
                map.putAll(this.cookies);
            }
            return CollectionUtils.isNotEmpty(map) ? DefaultRequestBodyUriSpec.serializeCookies(map) : null;
        }

        private static String serializeCookies(MultiValueMap<String, String> map) {
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : map.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    if (!first) {
                        sb.append("; ");
                    } else {
                        first = false;
                    }
                    sb.append((String)entry.getKey()).append('=').append(value);
                }
            }
            return sb.toString();
        }

        private static ResourceAccessException createResourceAccessException(URI url, HttpMethod method, IOException ex) {
            StringBuilder msg = new StringBuilder("I/O error on ");
            msg.append(method.name());
            msg.append(" request for \"");
            String urlString = url.toString();
            int idx = urlString.indexOf(63);
            if (idx != -1) {
                msg.append(urlString, 0, idx);
            } else {
                msg.append(urlString);
            }
            msg.append("\": ");
            msg.append(ex.getMessage());
            return new ResourceAccessException(msg.toString(), ex);
        }

        @FunctionalInterface
        private static interface InternalBody {
            public void writeTo(ClientHttpRequest var1) throws IOException;
        }
    }

    static interface ResponseConsumer {
        public void accept(ClientHttpResponse var1) throws IOException;
    }

    private class DefaultClientResponse
    implements ClientResponse {
        private final ClientHttpResponse delegate;

        public DefaultClientResponse(ClientHttpResponse delegate) {
            this.delegate = delegate;
        }

        @Override
        @Nullable
        public <T> T bodyTo(Class<T> bodyType) {
            return DefaultRestClient.this.readWithMessageConverters(this.delegate, null, bodyType, bodyType);
        }

        @Override
        @Nullable
        public <T> T bodyTo(ParameterizedTypeReference<T> bodyType) {
            Type type = bodyType.getType();
            Class bodyClass = DefaultRestClient.bodyClass(type);
            return DefaultRestClient.this.readWithMessageConverters(this.delegate, null, type, bodyClass);
        }

        @Override
        public InputStream getBody() throws IOException {
            return this.delegate.getBody();
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.delegate.getHeaders();
        }

        @Override
        public HttpStatusCode getStatusCode() {
            return this.delegate.getStatusCode();
        }

        @Override
        public int getRawStatusCode() {
            return this.delegate.getRawStatusCode();
        }

        @Override
        public String getStatusText() {
            return this.delegate.getStatusText();
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }

    private class DefaultAsyncSpec
    extends AbstractResponseSpec<DefaultAsyncSpec>
    implements RestClient.AsyncSpec {
        private final Future<ClientHttpResponse> clientResponse;

        DefaultAsyncSpec(HttpRequest clientRequest, Future<ClientHttpResponse> clientResponse) {
            super(clientRequest);
            this.clientResponse = clientResponse;
        }

        @Override
        public <T> Future<T> body(Class<T> bodyType) {
            return this.clientResponse.map(response -> ((DefaultAsyncSpec)this.ignoreStatus(false)).readBody((ClientHttpResponse)response, bodyType, bodyType));
        }

        @Override
        public <T> Future<T> body(ParameterizedTypeReference<T> bodyType) {
            return this.clientResponse.map(response -> {
                Type type = bodyType.getType();
                Class bodyClass = DefaultRestClient.bodyClass(type);
                return ((DefaultAsyncSpec)this.ignoreStatus(false)).readBody((ClientHttpResponse)response, type, bodyClass);
            });
        }

        @Override
        public <T> Future<ResponseEntity<T>> toEntity(Class<T> bodyType) {
            return this.toEntityInternal(bodyType, bodyType);
        }

        @Override
        public <T> Future<ResponseEntity<T>> toEntity(ParameterizedTypeReference<T> bodyType) {
            Type type = bodyType.getType();
            Class bodyClass = DefaultRestClient.bodyClass(type);
            return this.toEntityInternal(type, bodyClass);
        }

        @Override
        public Future<ResponseEntity<Void>> toBodilessEntity() {
            return this.clientResponse.map(this::toBodilessEntity);
        }

        private <T> Future<ResponseEntity<T>> toEntityInternal(Type bodyType, Class<T> bodyClass) {
            return this.clientResponse.map(response -> this.toEntityInternal((ClientHttpResponse)response, bodyType, bodyClass));
        }
    }

    private class DefaultResponseSpec
    extends AbstractResponseSpec<DefaultResponseSpec>
    implements RestClient.ResponseSpec {
        private final ClientHttpResponse clientResponse;

        DefaultResponseSpec(HttpRequest clientRequest, ClientHttpResponse clientResponse) {
            super(clientRequest);
            this.clientResponse = clientResponse;
        }

        @Override
        public <T> T body(Class<T> bodyType) {
            return ((DefaultResponseSpec)this.ignoreStatus(false)).readBody(this.clientResponse, bodyType, bodyType);
        }

        @Override
        public <T> T body(ParameterizedTypeReference<T> bodyType) {
            Type type = bodyType.getType();
            Class bodyClass = DefaultRestClient.bodyClass(type);
            return ((DefaultResponseSpec)this.ignoreStatus(false)).readBody(this.clientResponse, type, bodyClass);
        }

        @Override
        public <T> ResponseEntity<T> toEntity(Class<T> bodyType) {
            return this.toEntityInternal(this.clientResponse, bodyType, bodyType);
        }

        @Override
        public <T> ResponseEntity<T> toEntity(ParameterizedTypeReference<T> bodyType) {
            Type type = bodyType.getType();
            Class bodyClass = DefaultRestClient.bodyClass(type);
            return this.toEntityInternal(this.clientResponse, type, bodyClass);
        }

        @Override
        public ResponseEntity<Void> toBodilessEntity() {
            return this.toBodilessEntity(this.clientResponse);
        }
    }

    private abstract class AbstractResponseSpec<T extends AbstractResponseSpec<T>> {
        private final HttpRequest clientRequest;
        private final ArrayList<ResponseErrorHandler> statusHandlers = new ArrayList();
        private boolean ignoreStatus;

        private AbstractResponseSpec(HttpRequest clientRequest) {
            this.clientRequest = clientRequest;
            this.ignoreStatus = DefaultRestClient.this.ignoreStatusHandlers;
        }

        public T onStatus(Predicate<HttpStatusCode> statusPredicate, RestClient.ErrorHandler errorHandler) {
            return this.onStatusInternal(StatusHandler.of(statusPredicate, errorHandler));
        }

        public T onStatus(ResponseErrorHandler errorHandler) {
            return this.onStatusInternal(errorHandler);
        }

        public T ignoreStatus(boolean ignoreStatus) {
            this.ignoreStatus = ignoreStatus;
            return (T)this;
        }

        private T onStatusInternal(ResponseErrorHandler statusHandler) {
            this.statusHandlers.add(statusHandler);
            return (T)this;
        }

        final ResponseEntity<Void> toBodilessEntity(ClientHttpResponse response) throws ResourceAccessException {
            ClientHttpResponse clientHttpResponse = response;
            try {
                if (!this.ignoreStatus) {
                    DefaultRestClient.this.applyStatusHandlers(this.clientRequest, response, this.statusHandlers);
                }
                ResponseEntity<Void> responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.status(response.getStatusCode()).headers(response.getHeaders())).build();
                if (clientHttpResponse != null) {
                    clientHttpResponse.close();
                }
                return responseEntity;
            }
            catch (Throwable throwable) {
                try {
                    if (clientHttpResponse != null) {
                        try {
                            clientHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new ResourceAccessException("Could not retrieve response status code: " + ex.getMessage(), ex);
                }
            }
        }

        final <R> ResponseEntity<R> toEntityInternal(ClientHttpResponse response, Type bodyType, Class<R> bodyClass) {
            R body = this.readBody(response, bodyType, bodyClass);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status(response.getStatusCode()).headers(response.getHeaders())).body(body);
        }

        @Nullable
        final <R> R readBody(ClientHttpResponse clientResponse, Type bodyType, Class<R> bodyClass) {
            return DefaultRestClient.this.readWithMessageConverters(clientResponse, this.ignoreStatus ? null : response -> DefaultRestClient.this.applyStatusHandlers(this.clientRequest, response, this.statusHandlers), bodyType, bodyClass);
        }
    }
}

