/*
 * Decompiled with CFR 0.152.
 */
package infra.web.client;

import infra.core.ResolvableType;
import infra.http.HttpHeaders;
import infra.http.HttpRequest;
import infra.http.HttpStatusCode;
import infra.http.client.ClientHttpResponse;
import infra.http.client.ClientHttpResponseDecorator;
import infra.http.converter.HttpMessageConverter;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.util.LogFormatUtils;
import infra.util.ObjectUtils;
import infra.web.client.HttpClientErrorException;
import infra.web.client.HttpMessageConverterExtractor;
import infra.web.client.HttpServerErrorException;
import infra.web.client.ResponseErrorHandler;
import infra.web.client.RestClientException;
import infra.web.client.RestClientResponseException;
import infra.web.client.RestClientUtils;
import infra.web.client.UnknownHttpStatusCodeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class DefaultResponseErrorHandler
implements ResponseErrorHandler {
    @Nullable
    private List<HttpMessageConverter<?>> messageConverters;

    void setMessageConverters(List<HttpMessageConverter<?>> converters) {
        this.messageConverters = Collections.unmodifiableList(converters);
    }

    @Override
    public boolean hasError(ClientHttpResponse response) throws IOException {
        HttpStatusCode statusCode = response.getStatusCode();
        return this.hasError(statusCode);
    }

    protected boolean hasError(HttpStatusCode statusCode) {
        return statusCode.isError();
    }

    @Override
    public void handleError(HttpRequest request, ClientHttpResponse response) throws IOException {
        this.handleError(request, response, response.getStatusCode());
    }

    private String getErrorMessage(int rawStatusCode, String statusText, @Nullable byte[] responseBody, @Nullable Charset charset, HttpRequest request) {
        StringBuilder msg = new StringBuilder(rawStatusCode + " " + statusText);
        msg.append(" on ").append((Object)request.getMethod()).append(" request");
        msg.append(" for \"");
        String urlString = request.getURI().toString();
        int idx = urlString.indexOf(63);
        if (idx != -1) {
            msg.append(urlString, 0, idx);
        } else {
            msg.append(urlString);
        }
        msg.append("\": ");
        if (ObjectUtils.isEmpty((Object)responseBody)) {
            msg.append("[no body]");
        } else {
            charset = charset != null ? charset : StandardCharsets.UTF_8;
            String bodyText = new String(responseBody, charset);
            bodyText = LogFormatUtils.formatValue((Object)bodyText, (int)-1, (boolean)true);
            msg.append(bodyText);
        }
        return msg.toString();
    }

    protected void handleError(HttpRequest request, ClientHttpResponse response, HttpStatusCode statusCode) throws IOException {
        String statusText = response.getStatusText();
        HttpHeaders headers = response.getHeaders();
        byte[] body = this.getResponseBody(response);
        Charset charset = this.getCharset(response);
        String message = this.getErrorMessage(statusCode.value(), statusText, body, charset, request);
        RestClientResponseException ex = statusCode.is4xxClientError() ? HttpClientErrorException.create(message, statusCode, statusText, headers, body, charset) : (statusCode.is5xxServerError() ? HttpServerErrorException.create(message, statusCode, statusText, headers, body, charset) : new UnknownHttpStatusCodeException(message, statusCode.value(), statusText, headers, body, charset));
        if (CollectionUtils.isNotEmpty(this.messageConverters)) {
            ex.setBodyConvertFunction(this.initBodyConvertFunction(response, body, this.messageConverters));
        }
        throw ex;
    }

    protected Function<ResolvableType, ?> initBodyConvertFunction(ClientHttpResponse response, final byte[] body, List<HttpMessageConverter<?>> messageConverters) {
        return resolvable -> {
            try {
                HttpMessageConverterExtractor extractor = new HttpMessageConverterExtractor(resolvable.getType(), messageConverters);
                return extractor.extractData(new ClientHttpResponseDecorator(response){

                    @Override
                    public InputStream getBody() {
                        return new ByteArrayInputStream(body);
                    }
                });
            }
            catch (IOException ex) {
                throw new RestClientException("Error while extracting response for type [%s]".formatted(resolvable), ex);
            }
        };
    }

    protected byte[] getResponseBody(ClientHttpResponse response) {
        return RestClientUtils.getBody(response);
    }

    @Nullable
    protected Charset getCharset(ClientHttpResponse response) {
        return RestClientUtils.getCharset(response);
    }
}

