/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver.date;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;

abstract class DateUtils {
    DateUtils() {
    }

    public static LocalDateTime ofDateTime(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return (LocalDateTime)temporalAccessor;
        }
        return LocalDateTime.of(LocalDate.of(DateUtils.get(temporalAccessor, ChronoField.YEAR), DateUtils.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), DateUtils.get(temporalAccessor, ChronoField.DAY_OF_MONTH)), LocalTime.of(DateUtils.get(temporalAccessor, ChronoField.HOUR_OF_DAY), DateUtils.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR)));
    }

    public static LocalTime ofTime(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).toLocalTime();
        }
        return LocalTime.of(DateUtils.get(temporalAccessor, ChronoField.HOUR_OF_DAY), DateUtils.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR));
    }

    public static LocalDate ofDate(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).toLocalDate();
        }
        return LocalDate.of(DateUtils.get(temporalAccessor, ChronoField.YEAR), DateUtils.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), DateUtils.get(temporalAccessor, ChronoField.DAY_OF_MONTH));
    }

    public static int get(TemporalAccessor temporalAccessor, TemporalField field) {
        if (temporalAccessor.isSupported(field)) {
            return temporalAccessor.get(field);
        }
        return (int)field.range().getMinimum();
    }
}

