/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver.date;

import infra.format.annotation.DateTimeFormat;
import infra.util.StringUtils;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.bind.resolver.date.AbstractDateParameterResolver;
import infra.web.bind.resolver.date.DateParameterParsingException;
import infra.web.handler.method.ResolvableMethodParameter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateParameterResolver
extends AbstractDateParameterResolver
implements ParameterResolvingStrategy {
    private String defaultPattern = "yyyy-MM-dd HH:mm:ss";

    @Override
    public boolean supportsParameter(ResolvableMethodParameter parameter) {
        return parameter.is(Date.class);
    }

    @Override
    protected Object resolveInternal(String parameterValue, ResolvableMethodParameter parameter) {
        SimpleDateFormat simpleDateFormat = this.getFormatter(parameter);
        try {
            return simpleDateFormat.parse(parameterValue);
        }
        catch (ParseException e) {
            throw new DateParameterParsingException(parameter.getParameter(), parameterValue, (Throwable)e);
        }
    }

    protected SimpleDateFormat getFormatter(ResolvableMethodParameter parameter) {
        String pattern;
        DateTimeFormat dateTimeFormat = this.getAnnotation(parameter);
        if (dateTimeFormat != null && StringUtils.isNotEmpty((CharSequence)(pattern = dateTimeFormat.pattern()))) {
            return new SimpleDateFormat(pattern);
        }
        return new SimpleDateFormat(this.defaultPattern);
    }

    public void setDefaultPattern(String defaultPattern) {
        this.defaultPattern = defaultPattern;
    }

    public String getDefaultPattern() {
        return this.defaultPattern;
    }
}

