/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver.date;

import infra.format.annotation.DateTimeFormat;
import infra.lang.Assert;
import infra.util.StringUtils;
import infra.web.bind.resolver.date.AbstractDateParameterResolver;
import infra.web.bind.resolver.date.DateParameterParsingException;
import infra.web.handler.method.ResolvableMethodParameter;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;

public abstract class AbstractJavaTimeParameterResolver
extends AbstractDateParameterResolver {
    private DateTimeFormatter defaultFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    @Override
    protected Object resolveInternal(String parameterValue, ResolvableMethodParameter parameter) {
        DateTimeFormatter formatter = this.getFormatter(parameter);
        try {
            return this.fromTemporalAccessor(formatter.parse(parameterValue));
        }
        catch (DateTimeParseException e) {
            throw new DateParameterParsingException(parameter.getParameter(), parameterValue, (Throwable)e);
        }
    }

    protected Object fromTemporalAccessor(TemporalAccessor temporalAccessor) {
        return null;
    }

    protected DateTimeFormatter getFormatter(ResolvableMethodParameter parameter) {
        String pattern;
        DateTimeFormat dateTimeFormat = this.getAnnotation(parameter);
        if (dateTimeFormat != null && StringUtils.isNotEmpty((CharSequence)(pattern = dateTimeFormat.pattern()))) {
            return DateTimeFormatter.ofPattern(pattern);
        }
        return this.defaultFormatter;
    }

    public void setDefaultFormatter(DateTimeFormatter defaultFormatter) {
        Assert.notNull((Object)defaultFormatter, (String)"defaultFormatter is required");
        this.defaultFormatter = defaultFormatter;
    }

    public DateTimeFormatter getDefaultFormatter() {
        return this.defaultFormatter;
    }
}

