/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver.date;

import infra.format.annotation.DateTimeFormat;
import infra.lang.NullValue;
import infra.util.StringUtils;
import infra.web.RequestContext;
import infra.web.bind.resolver.ParameterResolvingStrategy;
import infra.web.handler.method.ResolvableMethodParameter;

public abstract class AbstractDateParameterResolver
implements ParameterResolvingStrategy {
    protected static final String FORMAT_ANNOTATION_KEY = AbstractDateParameterResolver.class.getName() + "-DateTimeFormat";

    @Override
    public abstract boolean supportsParameter(ResolvableMethodParameter var1);

    @Override
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        String parameterValue = this.getParameterValue(context, resolvable);
        if (StringUtils.isEmpty((CharSequence)parameterValue)) {
            return null;
        }
        return this.resolveInternal(parameterValue, resolvable);
    }

    protected Object resolveInternal(String parameterValue, ResolvableMethodParameter parameter) {
        return null;
    }

    protected String getParameterValue(RequestContext context, ResolvableMethodParameter parameter) {
        return context.getParameter(parameter.getName());
    }

    protected DateTimeFormat getAnnotation(ResolvableMethodParameter parameter) {
        Object attribute = parameter.getAttribute(FORMAT_ANNOTATION_KEY);
        if (attribute == null) {
            DateTimeFormat ret = parameter.getParameterAnnotation(DateTimeFormat.class);
            if (ret == null && (ret = (DateTimeFormat)parameter.getParameter().getMethodAnnotation(DateTimeFormat.class)) == null) {
                ret = parameter.getParameter().getContainingClass().getAnnotation(DateTimeFormat.class);
            }
            parameter.setAttribute(FORMAT_ANNOTATION_KEY, ret == null ? NullValue.INSTANCE : ret);
            return ret;
        }
        if (attribute == NullValue.INSTANCE) {
            return null;
        }
        return (DateTimeFormat)attribute;
    }
}

