/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.MethodParameter;
import infra.http.ProblemDetail;
import infra.http.converter.HttpMessageConverter;
import infra.http.converter.HttpMessageNotReadableException;
import infra.lang.Nullable;
import infra.web.ErrorResponse;
import infra.web.HttpMediaTypeNotSupportedException;
import infra.web.RequestContext;
import infra.web.accept.ContentNegotiationManager;
import infra.web.annotation.RequestBody;
import infra.web.bind.resolver.AbstractMessageConverterMethodProcessor;
import infra.web.handler.method.HandlerMethod;
import infra.web.handler.method.ResolvableMethodParameter;
import infra.web.handler.result.HandlerMethodReturnValueHandler;
import infra.web.view.ModelAndView;
import infra.web.view.View;
import infra.web.view.ViewRef;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;

public class RequestResponseBodyMethodProcessor
extends AbstractMessageConverterMethodProcessor
implements HandlerMethodReturnValueHandler {
    public RequestResponseBodyMethodProcessor(List<HttpMessageConverter<?>> converters) {
        super(converters);
    }

    public RequestResponseBodyMethodProcessor(List<HttpMessageConverter<?>> converters, @Nullable ContentNegotiationManager manager) {
        super(converters, manager);
    }

    public RequestResponseBodyMethodProcessor(List<HttpMessageConverter<?>> converters, @Nullable List<Object> requestResponseBodyAdvice) {
        super(converters, null, requestResponseBodyAdvice);
    }

    public RequestResponseBodyMethodProcessor(List<HttpMessageConverter<?>> converters, @Nullable ContentNegotiationManager manager, @Nullable List<Object> requestResponseBodyAdvice) {
        super(converters, manager, requestResponseBodyAdvice);
    }

    public RequestResponseBodyMethodProcessor(List<HttpMessageConverter<?>> converters, @Nullable ContentNegotiationManager manager, @Nullable List<Object> requestResponseBodyAdvice, List<ErrorResponse.Interceptor> interceptors) {
        super(converters, manager, requestResponseBodyAdvice, interceptors);
    }

    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        return resolvable.hasParameterAnnotation(RequestBody.class);
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        MethodParameter parameter = resolvable.getParameter();
        Object arg = this.readWithMessageConverters(context, parameter, parameter.getNestedGenericParameterType());
        this.validateIfApplicable(context, parameter, arg);
        return arg;
    }

    @Override
    protected Object readWithMessageConverters(RequestContext request, MethodParameter parameter, Type paramType) throws IOException, HttpMediaTypeNotSupportedException, HttpMessageNotReadableException {
        Object arg = super.readWithMessageConverters(request, parameter, paramType);
        if (arg == null && this.checkRequired(parameter)) {
            throw new HttpMessageNotReadableException("Required request body is missing: " + parameter.getExecutable().toGenericString(), request);
        }
        return arg;
    }

    protected boolean checkRequired(MethodParameter parameter) {
        RequestBody requestBody = (RequestBody)parameter.getParameterAnnotation(RequestBody.class);
        return requestBody != null && requestBody.required() && !parameter.isOptional();
    }

    @Override
    public boolean supportsHandlerMethod(HandlerMethod handler) {
        return handler.isResponseBody();
    }

    @Override
    public boolean supportsReturnValue(@Nullable Object returnValue) {
        return !(returnValue instanceof ModelAndView) && !(returnValue instanceof View) && !(returnValue instanceof ViewRef);
    }

    @Override
    public void handleReturnValue(RequestContext context, @Nullable Object handler, @Nullable Object returnValue) throws Exception {
        HandlerMethod handlerMethod;
        if (returnValue instanceof ProblemDetail) {
            ProblemDetail detail = (ProblemDetail)returnValue;
            context.setStatus(detail.getStatus());
            if (detail.getInstance() == null) {
                URI path = URI.create(context.getRequestURI());
                detail.setInstance(path);
            }
            this.invokeErrorResponseInterceptors(detail, null);
        }
        if ((handlerMethod = HandlerMethod.unwrap(handler)) != null) {
            this.writeWithMessageConverters(returnValue, handlerMethod.getReturnType(), context);
        } else if (returnValue != null) {
            this.writeWithMessageConverters(returnValue, null, context);
        }
    }
}

