/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.MethodParameter;
import infra.http.HttpInputMessage;
import infra.http.MediaType;
import infra.http.converter.HttpMessageConverter;
import infra.lang.Nullable;
import infra.util.CollectionUtils;
import infra.web.RequestContext;
import infra.web.handler.method.ControllerAdviceBean;
import infra.web.handler.method.RequestBodyAdvice;
import infra.web.handler.method.ResponseBodyAdvice;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RequestResponseBodyAdviceChain
implements RequestBodyAdvice,
ResponseBodyAdvice<Object> {
    private final ArrayList<Object> requestBodyAdvice = new ArrayList(4);
    private final ArrayList<Object> responseBodyAdvice = new ArrayList(4);

    public RequestResponseBodyAdviceChain(@Nullable List<Object> requestResponseBodyAdvice) {
        this.requestBodyAdvice.addAll(RequestResponseBodyAdviceChain.getAdviceByType(requestResponseBodyAdvice, RequestBodyAdvice.class));
        this.responseBodyAdvice.addAll(RequestResponseBodyAdviceChain.getAdviceByType(requestResponseBodyAdvice, ResponseBodyAdvice.class));
    }

    public static <T> List<T> getAdviceByType(@Nullable List<Object> bodyAdvice, Class<T> adviceType) {
        if (bodyAdvice != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object advice : bodyAdvice) {
                Class<?> beanType;
                Class<?> clazz;
                if (advice instanceof ControllerAdviceBean) {
                    ControllerAdviceBean adviceBean = (ControllerAdviceBean)advice;
                    clazz = adviceBean.getBeanType();
                } else {
                    clazz = advice.getClass();
                }
                if ((beanType = clazz) == null || !adviceType.isAssignableFrom(beanType)) continue;
                result.add(advice);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean supports(MethodParameter param, Type type, HttpMessageConverter<?> converter) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean supports(@Nullable Object body, @Nullable MethodParameter returnType, HttpMessageConverter<?> converter) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, HttpMessageConverter<?> converter) throws IOException {
        for (RequestBodyAdvice advice : this.getMatchingAdvice(parameter, RequestBodyAdvice.class, this.requestBodyAdvice)) {
            if (!advice.supports(parameter, targetType, converter)) continue;
            inputMessage = advice.beforeBodyRead(inputMessage, parameter, targetType, converter);
        }
        return inputMessage;
    }

    @Override
    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, HttpMessageConverter<?> converter) {
        for (RequestBodyAdvice advice : this.getMatchingAdvice(parameter, RequestBodyAdvice.class, this.requestBodyAdvice)) {
            if (!advice.supports(parameter, targetType, converter)) continue;
            body = advice.afterBodyRead(body, inputMessage, parameter, targetType, converter);
        }
        return body;
    }

    @Override
    @Nullable
    public Object beforeBodyWrite(@Nullable Object body, @Nullable MethodParameter returnType, MediaType contentType, HttpMessageConverter<?> converter, RequestContext context) {
        for (ResponseBodyAdvice advice : this.getMatchingAdvice(returnType, ResponseBodyAdvice.class, this.responseBodyAdvice)) {
            if (!advice.supports(body, returnType, converter)) continue;
            body = advice.beforeBodyWrite(body, returnType, contentType, converter, context);
        }
        return body;
    }

    @Override
    @Nullable
    public Object handleEmptyBody(@Nullable Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, HttpMessageConverter<?> converter) {
        for (RequestBodyAdvice advice : this.getMatchingAdvice(parameter, RequestBodyAdvice.class, this.requestBodyAdvice)) {
            if (!advice.supports(parameter, targetType, converter)) continue;
            body = advice.handleEmptyBody(body, inputMessage, parameter, targetType, converter);
        }
        return body;
    }

    private <A> List<A> getMatchingAdvice(@Nullable MethodParameter parameter, Class<? extends A> adviceType, List<Object> availableAdvice) {
        if (CollectionUtils.isEmpty(availableAdvice)) {
            return Collections.emptyList();
        }
        Class containingClass = null;
        ArrayList<Object> result = new ArrayList<Object>(availableAdvice.size());
        for (Object advice : availableAdvice) {
            if (advice instanceof ControllerAdviceBean) {
                ControllerAdviceBean adviceBean = (ControllerAdviceBean)advice;
                if (containingClass == null && parameter != null) {
                    containingClass = parameter.getContainingClass();
                }
                if (!adviceBean.isApplicableToBeanType(containingClass)) continue;
                advice = adviceBean.resolveBean();
            }
            if (!adviceType.isAssignableFrom(advice.getClass())) continue;
            result.add(advice);
        }
        return result;
    }
}

