/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.http.HttpHeaders;
import infra.http.HttpInputMessage;
import infra.http.MediaType;
import infra.http.client.support.HttpRequestDecorator;
import infra.util.CollectionUtils;
import infra.web.RequestContext;
import infra.web.bind.resolver.MissingRequestPartException;
import infra.web.multipart.Multipart;
import infra.web.multipart.MultipartFile;
import infra.web.multipart.MultipartRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class RequestPartServerHttpRequest
extends HttpRequestDecorator
implements HttpInputMessage {
    private final RequestContext request;
    private final String requestPartName;
    private final HttpHeaders multipartHeaders;
    private final MultipartRequest multipartRequest;

    public RequestPartServerHttpRequest(RequestContext request, String requestPartName) throws MissingRequestPartException {
        super(request);
        this.request = request;
        this.requestPartName = requestPartName;
        this.multipartRequest = request.getMultipartRequest();
        HttpHeaders multipartHeaders = this.multipartRequest.getMultipartHeaders(requestPartName);
        if (multipartHeaders == null) {
            throw new MissingRequestPartException(requestPartName);
        }
        this.multipartHeaders = multipartHeaders;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.multipartHeaders;
    }

    @Override
    public InputStream getBody() throws IOException {
        Multipart multipart = (Multipart)CollectionUtils.firstElement(this.multipartRequest.multipartData(this.requestPartName));
        if (multipart instanceof MultipartFile) {
            MultipartFile file = (MultipartFile)multipart;
            return file.getInputStream();
        }
        if (multipart != null) {
            return new ByteArrayInputStream(multipart.getBytes());
        }
        String paramValue = this.request.getParameter(this.requestPartName);
        if (paramValue != null) {
            return new ByteArrayInputStream(paramValue.getBytes(this.determineCharset()));
        }
        throw new MissingRequestPartException(this.requestPartName);
    }

    private Charset determineCharset() {
        Charset charset;
        MediaType contentType = this.getHeaders().getContentType();
        if (contentType != null && (charset = contentType.getCharset()) != null) {
            return charset;
        }
        return StandardCharsets.UTF_8;
    }
}

