/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.core.MethodParameter;
import infra.http.converter.HttpMessageConverter;
import infra.lang.Nullable;
import infra.web.RequestContext;
import infra.web.annotation.RequestParam;
import infra.web.annotation.RequestPart;
import infra.web.bind.MultipartException;
import infra.web.bind.resolver.AbstractMessageConverterMethodArgumentResolver;
import infra.web.bind.resolver.MissingRequestPartException;
import infra.web.bind.resolver.MultipartResolutionDelegate;
import infra.web.bind.resolver.RequestPartServerHttpRequest;
import infra.web.handler.method.NamedValueInfo;
import infra.web.handler.method.ResolvableMethodParameter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class RequestPartMethodArgumentResolver
extends AbstractMessageConverterMethodArgumentResolver {
    public RequestPartMethodArgumentResolver(List<HttpMessageConverter<?>> messageConverters) {
        super(messageConverters);
    }

    public RequestPartMethodArgumentResolver(List<HttpMessageConverter<?>> messageConverters, List<Object> requestResponseBodyAdvice) {
        super(messageConverters, requestResponseBodyAdvice);
    }

    @Override
    public boolean supportsParameter(ResolvableMethodParameter parameter) {
        if (parameter.hasParameterAnnotation(RequestPart.class)) {
            return true;
        }
        if (parameter.hasParameterAnnotation(RequestParam.class)) {
            return false;
        }
        return MultipartResolutionDelegate.isMultipartArgument(parameter.getParameter());
    }

    @Override
    @Nullable
    public Object resolveArgument(RequestContext context, ResolvableMethodParameter resolvable) throws Throwable {
        Object arg;
        String name;
        NamedValueInfo namedValueInfo;
        block6: {
            MethodParameter parameter = resolvable.getParameter();
            namedValueInfo = resolvable.getNamedValueInfo();
            name = namedValueInfo.name;
            arg = null;
            Object mpArg = MultipartResolutionDelegate.resolveMultipartArgument(name, parameter, context);
            if (mpArg != MultipartResolutionDelegate.UNRESOLVABLE) {
                arg = mpArg;
            } else {
                try {
                    RequestPartServerHttpRequest inputMessage = new RequestPartServerHttpRequest(context, name);
                    arg = this.readWithMessageConverters(inputMessage, parameter, parameter.getNestedGenericParameterType());
                    this.validateIfApplicable(context, parameter, arg);
                }
                catch (MultipartException | MissingRequestPartException ex) {
                    if (!namedValueInfo.required) break block6;
                    throw ex;
                }
            }
        }
        if (arg == null && namedValueInfo.required) {
            if (!context.isMultipart()) {
                throw new MultipartException("Current request is not a multipart request");
            }
            throw new MissingRequestPartException(name);
        }
        return arg;
    }

    @Override
    void closeStreamIfNecessary(InputStream body) {
        try {
            body.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

