/*
 * Decompiled with CFR 0.152.
 */
package infra.web.bind.resolver;

import infra.beans.BeanUtils;
import infra.beans.factory.config.ConfigurableBeanFactory;
import infra.core.MethodParameter;
import infra.core.TypeDescriptor;
import infra.core.conversion.ConversionService;
import infra.lang.Assert;
import infra.lang.Nullable;
import infra.util.StringUtils;
import infra.web.HandlerMatchingMetadata;
import infra.web.RequestContext;
import infra.web.annotation.RequestParam;
import infra.web.annotation.RequestPart;
import infra.web.bind.MissingRequestParameterException;
import infra.web.bind.MultipartException;
import infra.web.bind.resolver.AbstractNamedValueResolvingStrategy;
import infra.web.bind.resolver.MissingRequestPartException;
import infra.web.bind.resolver.MultipartResolutionDelegate;
import infra.web.handler.method.ResolvableMethodParameter;
import infra.web.handler.method.support.UriComponentsContributor;
import infra.web.multipart.Multipart;
import infra.web.util.UriComponentsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RequestParamMethodArgumentResolver
extends AbstractNamedValueResolvingStrategy
implements UriComponentsContributor {
    private static final TypeDescriptor STRING_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
    private final boolean useDefaultResolution;

    public RequestParamMethodArgumentResolver(boolean useDefaultResolution) {
        this.useDefaultResolution = useDefaultResolution;
    }

    public RequestParamMethodArgumentResolver(@Nullable ConfigurableBeanFactory beanFactory, boolean useDefaultResolution) {
        super(beanFactory);
        this.useDefaultResolution = useDefaultResolution;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(RequestParam.class)) {
            if (Map.class.isAssignableFrom(parameter.getParameterType())) {
                RequestParam requestParam = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
                return requestParam != null && StringUtils.hasText((String)requestParam.name());
            }
            return true;
        }
        if (parameter.hasParameterAnnotation(RequestPart.class)) {
            return false;
        }
        if (MultipartResolutionDelegate.isMultipartArgument(parameter)) {
            return true;
        }
        if (this.useDefaultResolution) {
            return BeanUtils.isSimpleProperty((Class)parameter.getParameterType());
        }
        return false;
    }

    @Override
    public boolean supportsParameter(ResolvableMethodParameter resolvable) {
        return this.supportsParameter(resolvable.getParameter());
    }

    @Override
    @Nullable
    protected Object resolveName(String name, ResolvableMethodParameter resolvable, RequestContext request) throws Exception {
        List<Multipart> parts;
        MethodParameter parameter = resolvable.getParameter();
        Object mpArg = MultipartResolutionDelegate.resolveMultipartArgument(name, parameter, request);
        if (mpArg != MultipartResolutionDelegate.UNRESOLVABLE) {
            return mpArg;
        }
        Object arg = null;
        String[] paramValues = request.getParameters(name);
        if (paramValues == null) {
            paramValues = request.getParameters(name + "[]");
        }
        if (paramValues != null) {
            arg = paramValues.length == 1 ? paramValues[0] : paramValues;
        } else {
            HandlerMatchingMetadata matchingMetadata = request.getMatchingMetadata();
            if (matchingMetadata != null) {
                arg = matchingMetadata.getUriVariable(name);
            }
        }
        if (arg == null && request.isMultipart() && (parts = request.getMultipartRequest().multipartData(name)) != null) {
            arg = parts.size() == 1 ? parts.get(0) : parts;
        }
        return arg;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter, RequestContext request) throws Exception {
        this.handleMissingValueInternal(name, parameter, request, false);
    }

    @Override
    protected void handleMissingValueAfterConversion(String name, MethodParameter parameter, RequestContext request) throws Exception {
        this.handleMissingValueInternal(name, parameter, request, true);
    }

    protected void handleMissingValueInternal(String name, MethodParameter parameter, RequestContext request, boolean missingAfterConversion) throws Exception {
        if (MultipartResolutionDelegate.isMultipartArgument(parameter)) {
            if (!request.isMultipart()) {
                throw new MultipartException("Current request is not a multipart request");
            }
            throw new MissingRequestPartException(name);
        }
        throw new MissingRequestParameterException(name, parameter, missingAfterConversion);
    }

    @Override
    public void contributeMethodArgument(MethodParameter parameter, @Nullable Object value, UriComponentsBuilder builder, Map<String, Object> uriVariables, ConversionService conversionService) {
        Class paramType = parameter.getNestedParameterType();
        if (Map.class.isAssignableFrom(paramType)) {
            return;
        }
        RequestParam requestParam = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        String name = requestParam != null && StringUtils.isNotEmpty((CharSequence)requestParam.name()) ? requestParam.name() : parameter.getParameterName();
        Assert.state((name != null ? 1 : 0) != 0, (String)"Unresolvable parameter name");
        if (value instanceof Optional) {
            Optional optional = (Optional)value;
            value = optional.orElse(null);
        }
        if (value == null) {
            if (!(requestParam == null || requestParam.required() && requestParam.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n"))) {
                return;
            }
            builder.queryParam(name, new Object[0]);
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                element = this.formatUriValue(conversionService, TypeDescriptor.nested((MethodParameter)parameter, (int)1), element);
                builder.queryParam(name, element);
            }
        } else {
            builder.queryParam(name, this.formatUriValue(conversionService, new TypeDescriptor(parameter), value));
        }
    }

    @Nullable
    protected String formatUriValue(@Nullable ConversionService cs, @Nullable TypeDescriptor sourceType, @Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (cs != null) {
            return (String)cs.convert(value, sourceType, STRING_TYPE_DESCRIPTOR);
        }
        return value.toString();
    }
}

